/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.config.conf.license;

import ch.transsoft.edec.model.config.conf.license.BillingStateEnum;
import ch.transsoft.edec.model.config.conf.license.CertificateInfo;
import ch.transsoft.edec.model.config.conf.license.LicenseStateEnum;
import ch.transsoft.edec.model.config.conf.license.RegistrationInfo;
import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.enumType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.LicenseUtil;
import java.util.Date;

public final class LicenseInfo
extends ModelNode<LicenseInfo> {
    private StringNode guid;
    private IntegralNode license1;
    private IntegralNode license2;
    private IntegralNode licenseEvvImport1;
    private IntegralNode licenseEvvImport2;
    private IntegralNode licenseEvvExport1;
    private IntegralNode licenseEvvExport2;
    @defaultValue(value="DEMO")
    @enumType(value=LicenseStateEnum.class)
    private EnumNode<LicenseStateEnum> licenseState;
    @defaultValue(value="DEMO")
    @enumType(value=LicenseStateEnum.class)
    private EnumNode<LicenseStateEnum> licenseEvvImportState;
    @defaultValue(value="DEMO")
    @enumType(value=LicenseStateEnum.class)
    private EnumNode<LicenseStateEnum> licenseEvvExportState;
    @defaultValue(value="CLOSED")
    @enumType(value=BillingStateEnum.class)
    private EnumNode<BillingStateEnum> billingState;
    private StringNode zazNumber;
    private DateNode evvImportStartDate;
    @mandatory
    private CertificateInfo certificate;
    @mandatory
    private RegistrationInfo registration;
    @defaultValue(value="false")
    @mandatory
    private BooleanNode startInTestMode;

    private boolean isLicenseChecked() {
        return this.license1.isInitialized() && this.license2.isInitialized() && this.license2.getValue() == LicenseUtil.computeLicense2(this.license1.getValue());
    }

    private boolean isLicenseEvvImportChecked() {
        return this.licenseEvvImport1.isInitialized() && this.licenseEvvImport2.isInitialized() && this.licenseEvvImport2.getValue() == LicenseUtil.computeLicense2(this.licenseEvvImport1.getValue());
    }

    private boolean isLicenseEvvExportChecked() {
        return this.licenseEvvExport1.isInitialized() && this.licenseEvvExport2.isInitialized() && this.licenseEvvExport2.getValue() == LicenseUtil.computeLicense2(this.licenseEvvExport1.getValue());
    }

    public void buyLicenseEdecExport() {
        long d1 = new Date().getTime();
        this.license1.setValue(d1);
        this.license2.setValue(LicenseUtil.computeLicense2(d1));
        this.licenseState.setValue(LicenseStateEnum.LICENSED);
    }

    public void buyLicenseEvvExport() {
        long d1 = new Date().getTime();
        this.licenseEvvExport1.setValue(d1);
        this.licenseEvvExport2.setValue(LicenseUtil.computeLicense2(d1));
        this.licenseEvvExportState.setValue(LicenseStateEnum.LICENSED);
    }

    public void buyLicenseEvvImport(String zazNumberStr, Date startDate) {
        long d1 = new Date().getTime();
        this.licenseEvvImport1.setValue(d1);
        this.licenseEvvImport2.setValue(LicenseUtil.computeLicense2(d1));
        this.licenseEvvImportState.setValue(LicenseStateEnum.LICENSED);
        this.zazNumber.setValue(zazNumberStr);
        this.evvImportStartDate.setValue(startDate);
    }

    public StringNode getGuid() {
        return this.guid;
    }

    public CertificateInfo getCertificate() {
        return this.certificate;
    }

    public RegistrationInfo getRegistration() {
        return this.registration;
    }

    public String getGuidValue() {
        return this.getGuid().getValue();
    }

    public EnumNode<LicenseStateEnum> getLicenseState() {
        return this.licenseState;
    }

    public EnumNode<LicenseStateEnum> getLicenseEvvImportState() {
        return this.licenseEvvImportState;
    }

    public EnumNode<LicenseStateEnum> getLicenseEvvExportState() {
        return this.licenseEvvExportState;
    }

    public EnumNode<BillingStateEnum> getBillingState() {
        return this.billingState;
    }

    public LicenseStateEnum getLicenseStateEdecExportValue() {
        return this.getLicenseState().getValue();
    }

    public void setLicenseStateEdecExportValue(LicenseStateEnum licenseState) {
        if (licenseState == LicenseStateEnum.DEMO) {
            this.getLicenseState().setValue(LicenseStateEnum.DEMO);
            this.license1.clear();
            this.license2.clear();
        } else if (licenseState == LicenseStateEnum.LICENSED) {
            this.buyLicenseEdecExport();
        } else if (licenseState == LicenseStateEnum.STUDENT) {
            this.getLicenseState().setValue(LicenseStateEnum.STUDENT);
            this.license1.clear();
            this.license2.clear();
        } else if (licenseState == LicenseStateEnum.CLOSED) {
            this.getLicenseState().setValue(LicenseStateEnum.CLOSED);
            this.license1.clear();
            this.license2.clear();
        } else {
            Check.fail("unexpected LicenseState " + licenseState);
        }
    }

    public LicenseStateEnum getLicenseStateEvvImportValue() {
        return this.getLicenseEvvImportState().getValue();
    }

    public void setLicenseStateEvvImportValue(LicenseStateEnum licenseState) {
        if (licenseState == LicenseStateEnum.DEMO) {
            this.getLicenseEvvImportState().setValue(LicenseStateEnum.DEMO);
            this.licenseEvvImport1.clear();
            this.licenseEvvImport2.clear();
        } else if (licenseState == LicenseStateEnum.LICENSED) {
            this.buyLicenseEvvImport("00000", new Date());
        } else if (licenseState == LicenseStateEnum.STUDENT) {
            this.getLicenseEvvImportState().setValue(LicenseStateEnum.STUDENT);
            this.licenseEvvImport1.clear();
            this.licenseEvvImport2.clear();
        } else if (licenseState == LicenseStateEnum.CLOSED) {
            this.getLicenseEvvImportState().setValue(LicenseStateEnum.CLOSED);
            this.licenseEvvImport1.clear();
            this.licenseEvvImport2.clear();
        } else {
            Check.fail("unexpected LicenseState " + licenseState);
        }
    }

    public LicenseStateEnum getLicenseStateEvvExportValue() {
        if (this.hasLicenseForModuleEdecExport()) {
            return LicenseStateEnum.LICENSED;
        }
        return this.getLicenseStateEvvExportRawValue();
    }

    public LicenseStateEnum getLicenseStateEvvExportRawValue() {
        return this.getLicenseEvvExportState().getValue();
    }

    public void setLicenseStateEvvExportValue(LicenseStateEnum licenseState) {
        if (licenseState == LicenseStateEnum.DEMO) {
            this.getLicenseEvvExportState().setValue(LicenseStateEnum.DEMO);
            this.licenseEvvExport1.clear();
            this.licenseEvvExport2.clear();
        } else if (licenseState == LicenseStateEnum.LICENSED) {
            this.buyLicenseEvvExport();
        } else if (licenseState == LicenseStateEnum.STUDENT) {
            this.getLicenseEvvExportState().setValue(LicenseStateEnum.STUDENT);
            this.licenseEvvExport1.clear();
            this.licenseEvvExport2.clear();
        } else if (licenseState == LicenseStateEnum.CLOSED) {
            this.getLicenseEvvExportState().setValue(LicenseStateEnum.CLOSED);
            this.licenseEvvExport1.clear();
            this.licenseEvvExport2.clear();
        } else {
            Check.fail("unexpected LicenseState " + licenseState);
        }
    }

    public BillingStateEnum getbillingStateValue() {
        return this.getBillingState().getValue();
    }

    public StringNode getZazNumber() {
        return this.zazNumber;
    }

    public DateNode getEvvImportStartDate() {
        return this.evvImportStartDate;
    }

    public BooleanNode getStartInTestMode() {
        return this.startInTestMode;
    }

    public boolean hasLicense() {
        return this.hasLicenseForModuleEdecExport() || this.hasLicenseForModuleEvvImport() || this.hasLicenseForModuleEvvExport();
    }

    public boolean hasLicenseForModuleEvvImport() {
        return this.getLicenseStateEvvImportValue() == LicenseStateEnum.LICENSED;
    }

    public boolean hasLicenseForModuleEdecExport() {
        return this.getLicenseStateEdecExportValue() == LicenseStateEnum.LICENSED;
    }

    public boolean hasLicenseForModuleEvvExport() {
        return this.getLicenseStateEvvExportValue() == LicenseStateEnum.LICENSED;
    }
}

