/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.config.conf.printer;

import ch.transsoft.edec.model.config.conf.printer.CorrectionData;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.annotation.listType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;

public final class FormPagePrinterCorrection
extends ModelNode<FormPagePrinterCorrection> {
    @mandatory
    @listType(value=CorrectionData.class)
    private ListNode<CorrectionData> correctionDatas;

    public ListNode<CorrectionData> getCorrectionDatas() {
        return this.correctionDatas;
    }

    public void setCorrectionDatas(ListNode<CorrectionData> correctionDatas) {
        this.correctionDatas = correctionDatas;
    }

    public CorrectionData getCorrectionData(String printerId) {
        CorrectionData result = this.findCorrectionData(printerId);
        if (result != null) {
            return result;
        }
        return this.createNew(printerId);
    }

    private CorrectionData createNew(String printerId) {
        CorrectionData result = this.correctionDatas.isEmpty() ? NodeFactory.create(CorrectionData.class) : (CorrectionData)this.correctionDatas.get(0).getCopy((ModelNode)null);
        result.getPrinterId().setValue(printerId);
        this.correctionDatas.add(result);
        return result;
    }

    public CorrectionData findCorrectionData(String printerId) {
        for (CorrectionData correction : this.correctionDatas) {
            if (!correction.getPrinterId().getValue().equals(printerId)) continue;
            return correction;
        }
        return null;
    }
}

