/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.ReceiptDesc;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.annotation.decimalSpec;
import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.listType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.BinaryNode;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.RootNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.util.Check;

public final class BordereauInfo
extends ModelNode<BordereauInfo>
implements RootNode<BordereauInfo> {
    @mandatory
    @defaultValue(value="0")
    private IntegralNode state;
    @mandatory
    private BinaryNode data;
    @mandatory
    private BinaryNode validationProtocol;
    @mandatory
    private BooleanNode archive;
    @mandatory
    private StringNode bordereauNumber;
    @mandatory
    @defaultValue(value="false")
    private BooleanNode complete;
    @mandatory
    private EdecDateNode creationDate;
    @mandatory
    private IntegralNode accountNumber;
    @mandatory
    private StringNode accountName;
    @decimalSpec(totalDigits=3, fractionDigits=2)
    @mandatory
    private DecimalNode totalAmount;
    @mandatory
    private IntegralNode zNumberOfDocs;
    @decimalSpec(totalDigits=3, fractionDigits=2)
    @mandatory
    private DecimalNode zAmount;
    @mandatory
    private StringNode zInvoice;
    @mandatory
    private IntegralNode mNumberOfDocs;
    @decimalSpec(totalDigits=3, fractionDigits=2)
    @mandatory
    private DecimalNode mAmount;
    @mandatory
    private StringNode mInvoice;
    @mandatory
    private IntegralNode totalNumberOfDocs;
    @mandatory
    @listType(value=ReceiptDesc.class)
    private ListNode<ReceiptDesc> receiptDescs;

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    public BordereauEntry createBordereauEntry() {
        BordereauEntry result = NodeFactory.create(BordereauEntry.class);
        result.setCreationDate(this.getCreationDate());
        Check.assertTrue(result.getCreationDate().isInitialized(), "Creation date not initialized for bordereau " + this.getBordereauNumber());
        result.setDocState(this.getState());
        result.setBordereauNumber(this.getBordereauNumber());
        result.setComplete(this.getComplete());
        result.setAccountNumber(this.getAccountNumber());
        result.setAccoutName(this.getAccountName());
        result.setTotalNumberOfDocs(this.getTotalNumberOfDocs());
        result.setTotalAmount(this.getTotalAmount());
        result.setZNumberOfDocs(this.getZNumberOfDocs());
        result.setZAmount(this.getZAmount());
        result.setZInvoice(this.getZInvoice());
        result.setMNumberOfDocs(this.getMNumberOfDocs());
        result.setMAmount(this.getMAmount());
        result.setMInvoice(this.getMInvoice());
        return result;
    }

    public BooleanNode getArchive() {
        return this.archive;
    }

    public IntegralNode getState() {
        return this.state;
    }

    public BinaryNode getData() {
        return this.data;
    }

    public BinaryNode getValidationProtocol() {
        return this.validationProtocol;
    }

    public StringNode getBordereauNumber() {
        return this.bordereauNumber;
    }

    public BooleanNode getComplete() {
        return this.complete;
    }

    public EdecDateNode getCreationDate() {
        return this.creationDate;
    }

    public String getDocumentDate() {
        return this.creationDate.toString();
    }

    public IntegralNode getAccountNumber() {
        return this.accountNumber;
    }

    public StringNode getAccountName() {
        return this.accountName;
    }

    public IntegralNode getTotalNumberOfDocs() {
        return this.totalNumberOfDocs;
    }

    public DecimalNode getTotalAmount() {
        return this.totalAmount;
    }

    public ListNode<ReceiptDesc> getReceiptDescs() {
        return this.receiptDescs;
    }

    public IntegralNode getZNumberOfDocs() {
        return this.zNumberOfDocs;
    }

    public DecimalNode getZAmount() {
        return this.zAmount;
    }

    public StringNode getZInvoice() {
        return this.zInvoice;
    }

    public IntegralNode getMNumberOfDocs() {
        return this.mNumberOfDocs;
    }

    public DecimalNode getMAmount() {
        return this.mAmount;
    }

    public StringNode getMInvoice() {
        return this.mInvoice;
    }

    public String getBordereauNumberStr() {
        return this.getBordereauNumber().getValue();
    }
}

