/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.evvimport.bordereau;

import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.util.Date;

public final class BordereauZazFetchInfo
extends ListEntry<BordereauZazFetchInfo> {
    @mandatory
    private StringNode accountNumber;
    @mandatory
    private EdecDateNode lastFetchDate;

    public StringNode getAccountNumber() {
        return this.accountNumber;
    }

    public EdecDateNode getLastFetchDate() {
        return this.lastFetchDate;
    }

    public EdecDateNode getFixedLastFetchDate() {
        Check.assertTrue(this.getLastFetchDate().isInitialized(), "lastFetchDate not initialized");
        EdecDateNode result = this.getLastFetchDate();
        if (DateUtil.toDate(result).after(new Date())) {
            result = new EdecDateNode(result.getYear(), result.getMonth() - 1, result.getDay());
        }
        return result;
    }

    public void updateLastFetchDate(EdecDateNode value) {
        if (!this.getLastFetchDate().isInitialized()) {
            this.getLastFetchDate().apply(value);
            return;
        }
        if (this.getFixedLastFetchDate().before(value)) {
            this.getLastFetchDate().apply(value);
        }
    }
}

