/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.enumType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.ConstStringNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.RootNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.ImpXmlDomWrapper;
import ch.transsoft.edec.ui.dialog.option.pm.moduleimp.ImpColDesc;
import ch.transsoft.edec.ui.dialog.option.pm.moduleimp.ImpColDescFactory;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DocumentUtil;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ImportSending
extends ListEntry<ImportSending>
implements RootNode<ImportSending> {
    public static final int DECLARATION_TYPE_PROVISORISCH = 2;
    @mandatory
    private ReceiptDocument vvz;
    @mandatory
    private ReceiptDocument vvm;
    @mandatory
    private ReceiptDocument rbz;
    @mandatory
    private ReceiptDocument rbm;
    @mandatory
    private IntegralNode declarationType;
    @mandatory
    private StringNode customsReferenceNumber;
    @mandatory
    private EdecDateNode date;
    @mandatory
    private StringNode bordereauNumber;
    @mandatory
    private StringNode orderNumber;
    @mandatory
    @enumType(value=ReceiptSource.class)
    @defaultValue(value="bordereau")
    private EnumNode<ReceiptSource> receiptSource;
    @mandatory
    private BooleanNode archive;
    @mandatory
    private BooleanNode star;

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    public ReceiptEntry createReceiptEntry() {
        ReceiptEntry result = new ReceiptEntry();
        result.setMandatory(false);
        result.setDate(this.getDate());
        result.setCustomsReferenceNumber(this.getCustomsReferenceNumber());
        List<ImpColDesc> colDescs = ImpColDescFactory.getColDescs(Services.get(IConfigService.class).getOptionInfo().getModuleImportInfo());
        if (this.fieldEnabled(1, colDescs)) {
            result.setVvz(this.getVvz().getState());
        }
        if (this.fieldEnabled(2, colDescs)) {
            result.setVvm(this.getVvm().getState());
        }
        if (this.fieldEnabled(3, colDescs)) {
            result.setRbz(this.getRbz().getState());
        }
        if (this.fieldEnabled(4, colDescs)) {
            result.setRbm(this.getRbm().getState());
        }
        if (this.fieldEnabled(18, colDescs)) {
            result.setBordereauNumber(this.getBordereauNumber());
            result.setReceiptSource(this.getReceiptSource().getValue());
        }
        if (this.fieldEnabled(19, colDescs)) {
            result.setOrderNumber(this.getOrderNumber());
        }
        if (this.fieldEnabled(27, colDescs)) {
            result.setStar(this.getStar());
        }
        this.readFromReceipts(result, colDescs);
        return result;
    }

    private boolean fieldEnabled(int id, List<ImpColDesc> colDescs) {
        for (ImpColDesc desc : colDescs) {
            if (desc.getIntId() != id) continue;
            return desc.isEnabled();
        }
        throw Check.fail("unknown ImportColDescXml id: " + id);
    }

    private void readFromReceipts(ReceiptEntry result, List<ImpColDesc> colDescs) {
        Document mainDoc;
        Document vvmDoc = this.getVvmDoc();
        Document vvzDoc = this.getVvzDoc();
        Document document = mainDoc = vvmDoc != null ? vvmDoc : vvzDoc;
        if (mainDoc == null) {
            mainDoc = this.getRbmDoc();
        }
        if (mainDoc == null) {
            mainDoc = this.getRbzDoc();
        }
        result.setDeclarationType(this.getDeclarationType(mainDoc));
        if (this.fieldEnabled(7, colDescs)) {
            result.setCustomsOffice(this.getCustomsOffice(mainDoc));
        }
        if (this.fieldEnabled(8, colDescs)) {
            result.setDeclarant(this.getDeclarant(mainDoc));
        }
        if (this.fieldEnabled(9, colDescs)) {
            result.setImporter(this.getImporter(mainDoc));
        }
        if (this.fieldEnabled(10, colDescs)) {
            result.setConsignee(this.getConsignee(mainDoc));
        }
        if (this.fieldEnabled(11, colDescs)) {
            result.setConsigneeCity(ImportSending.getConsigneeCity(mainDoc));
        }
        if (this.fieldEnabled(12, colDescs)) {
            result.setConsigneeCountry(this.getConsigneeCountry(mainDoc));
        }
        if (this.fieldEnabled(13, colDescs)) {
            result.setTotalVAT(this.getTotalVAT(vvmDoc));
        }
        if (this.fieldEnabled(14, colDescs)) {
            result.setTotalDuty(this.getTotalDuty(vvzDoc));
        }
        if (this.fieldEnabled(15, colDescs)) {
            result.setConsignorName(this.getConsignorName(mainDoc));
        }
        if (this.fieldEnabled(16, colDescs)) {
            result.setConsignorCity(this.getConsignorCity(mainDoc));
        }
        if (this.fieldEnabled(17, colDescs)) {
            result.setConsignorCountry(this.getConsignorCountry(mainDoc));
        }
        if (this.fieldEnabled(20, colDescs)) {
            result.setPreference(ImportSending.getPreference(vvmDoc));
        }
        if (this.fieldEnabled(21, colDescs)) {
            result.setPermitNumber(ImportSending.getPermitNumber(mainDoc));
        }
        if (this.fieldEnabled(22, colDescs)) {
            result.setPermitAuthority(ImportSending.getPermitAuthority(mainDoc));
        }
        if (this.fieldEnabled(23, colDescs)) {
            result.setImporterReference(this.getImporterReference(mainDoc));
        }
        if (this.fieldEnabled(24, colDescs)) {
            result.setConsignorReference(this.getConsignorReference(mainDoc));
        }
        if (this.fieldEnabled(25, colDescs)) {
            result.setConsigneeReference(this.getConsigneeReference(mainDoc));
        }
        if (this.fieldEnabled(26, colDescs)) {
            result.setTraderReference(this.getTraderReference(mainDoc));
        }
        if (this.fieldEnabled(28, colDescs)) {
            result.setConsigneeUid(this.getConsigneeUid(mainDoc));
        }
        if (this.fieldEnabled(29, colDescs)) {
            result.setImporterUid(this.getImporterUid(mainDoc));
        }
        if (this.fieldEnabled(30, colDescs)) {
            result.setMonopol(this.getMonopol(vvzDoc));
        }
        if (this.fieldEnabled(31, colDescs)) {
            result.setCustomsClearanceType(ImportSending.getCustomsClearanceType(mainDoc));
        }
    }

    private DecimalNode getTotalVAT(Document doc) {
        DecimalNode result = new DecimalNode(12, 2);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("VAT");
        if (element.getLength() != 0) {
            DocumentUtil.setDecimal(result, (Element)element.item(0), "totalAmount");
        }
        return result;
    }

    private DecimalNode getTotalDuty(Document doc) {
        DecimalNode result = new DecimalNode(12, 2);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("dutyAndAdditionalTaxes");
        if (element.getLength() != 0) {
            DocumentUtil.setDecimal(result, (Element)element.item(0), "totalAmount");
        }
        return result;
    }

    private DecimalNode getMonopol(Document doc) {
        DecimalNode result = new DecimalNode(12, 2);
        if (doc == null) {
            return result;
        }
        String path = "/Envelope/Body/receiptRequestResponse/taxationDecisionCustomsDuties/valuationSummary/dutyAndAdditionalTaxes/detailAmount[type=280]/amount";
        XPathExpression expression = ImpXmlDomWrapper.createExpression(path);
        try {
            Number dec = (Number)expression.evaluate(doc, XPathConstants.NUMBER);
            if (!Double.isNaN(dec.doubleValue())) {
                result.setValue(dec);
            }
        }
        catch (XPathExpressionException e2) {
            return result;
        }
        return result;
    }

    private StringNode getConsignorCountry(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("consignor");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "country");
        }
        return result;
    }

    public StringNode getDocumentVersion(ReceiptDocumentType type) {
        Document doc = this.getDoc(type);
        return this.getDocumentVersion(doc);
    }

    private StringNode getDocumentVersion(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("documentInformation");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "documentVersion");
        }
        return result;
    }

    private StringNode getConsignorCity(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("consignor");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "city");
        }
        return result;
    }

    private StringNode getConsignorName(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("consignor");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "name");
        }
        return result;
    }

    private StringNode getImporter(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("importer");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "name");
        }
        return result;
    }

    private StringNode getImporterReference(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("importer");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "importerReference");
        }
        return result;
    }

    private StringNode getImporterUid(Document doc) {
        StringNode result = new StringNode();
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("importer");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "traderIdentificationNumber");
        }
        return result;
    }

    private StringNode getConsigneeReference(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("consignee");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "consigneeReference");
        }
        return result;
    }

    private StringNode getTraderReference(Document doc) {
        StringNode result = new StringNode();
        if (doc == null) {
            return result;
        }
        DocumentUtil.setString(result, doc, "traderReference");
        return result;
    }

    private StringNode getConsignorReference(Document doc) {
        StringNode result = new StringNode();
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("consignor");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "consignorReference");
        }
        return result;
    }

    private StringNode getConsigneeUid(Document doc) {
        StringNode result = new StringNode();
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("consignee");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "traderIdentificationNumber");
        }
        return result;
    }

    private StringNode getConsignee(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("consignee");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "name");
        }
        return result;
    }

    public static StringNode getConsigneeCity(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("consignee");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "city");
        }
        return result;
    }

    private StringNode getConsigneeCountry(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("consignee");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "country");
        }
        return result;
    }

    private StringNode getDeclarant(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("declarant");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "name");
        }
        return result;
    }

    private StringNode getCustomsOffice(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("customsOffice");
        if (element.getLength() != 0) {
            DocumentUtil.setString(result, (Element)element.item(0), "name");
        }
        return result;
    }

    public static IntegralNode getPreference(Document doc) {
        if (doc == null) {
            return new IntegralNode();
        }
        NodeList element = doc.getElementsByTagName("origin");
        HashSet<Long> result = new HashSet<Long>();
        for (int i2 = 0; i2 < element.getLength(); ++i2) {
            IntegralNode value = new IntegralNode();
            DocumentUtil.setInteger(value, (Element)element.item(i2), "preference");
            if (!value.isInitialized()) continue;
            result.add(value.getValue());
        }
        if (result.isEmpty()) {
            return new IntegralNode(-2L);
        }
        if (result.size() > 1) {
            return new IntegralNode(2L);
        }
        return new IntegralNode((Long)result.iterator().next());
    }

    public static IntegralNode getCustomsClearanceType(Document doc) {
        if (doc == null) {
            return new IntegralNode();
        }
        NodeList element = doc.getElementsByTagName("statistic");
        HashSet<Long> result = new HashSet<Long>();
        for (int i2 = 0; i2 < element.getLength(); ++i2) {
            IntegralNode value = new IntegralNode();
            DocumentUtil.setInteger(value, (Element)element.item(i2), "customsClearanceType");
            if (!value.isInitialized()) continue;
            result.add(value.getValue());
        }
        if (result.isEmpty()) {
            return new IntegralNode(-2L);
        }
        if (result.size() > 1) {
            return new IntegralNode(-1L);
        }
        return new IntegralNode((Long)result.iterator().next());
    }

    public static StringNode getPermitNumber(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("permit");
        if (element.getLength() == 0) {
            return result;
        }
        DocumentUtil.setString(result, (Element)element.item(0), "permitNumber");
        return result;
    }

    public static StringNode getPermitAuthority(Document doc) {
        StringNode result = new StringNode(null);
        if (doc == null) {
            return result;
        }
        NodeList element = doc.getElementsByTagName("permit");
        if (element.getLength() == 0) {
            return result;
        }
        DocumentUtil.setString(result, (Element)element.item(0), "permitAuthority");
        return result;
    }

    private IntegralNode getDeclarationType(Document doc) {
        IntegralNode result = new IntegralNode();
        if (doc == null) {
            return result;
        }
        DocumentUtil.setInteger(result, doc, "declarationType");
        return result;
    }

    private Document getVvmDoc() {
        return this.getDoc(this.getVvm());
    }

    private Document getVvzDoc() {
        return this.getDoc(this.getVvz());
    }

    private Document getRbmDoc() {
        return this.getDoc(this.getRbm());
    }

    private Document getRbzDoc() {
        return this.getDoc(this.getRbz());
    }

    public Document getDoc(ReceiptDocumentType type) {
        ReceiptDocument receiptDocument = this.getReceiptDocument(type);
        return this.getDoc(receiptDocument);
    }

    public Document getDoc(ReceiptDocument doc) {
        if (!doc.hasDocument()) {
            return null;
        }
        InputStream input = doc.getData().asInputStream();
        try {
            return DocumentUtil.readXmlDoc(input);
        }
        catch (Exception e2) {
            throw Check.fail(e2, "Error when reading vvm content for ImportSending " + this.getDate());
        }
    }

    public ReceiptDocument getReceiptDocument(ReceiptDocumentType receiptDocumentType) {
        switch (receiptDocumentType) {
            case vvz: {
                return this.getVvz();
            }
            case vvm: {
                return this.getVvm();
            }
            case rbz: {
                return this.getRbz();
            }
            case rbm: {
                return this.getRbm();
            }
        }
        throw Check.fail("Unexpected ReceiptDocumentType " + receiptDocumentType);
    }

    public ReceiptDocument getVvz() {
        return this.vvz;
    }

    public ReceiptDocument getVvm() {
        return this.vvm;
    }

    public ReceiptDocument getRbz() {
        return this.rbz;
    }

    public ReceiptDocument getRbm() {
        return this.rbm;
    }

    public StringNode getCustomsReferenceNumber() {
        return this.customsReferenceNumber;
    }

    public EdecDateNode getDate() {
        return this.date;
    }

    public String getDateAsString() {
        return this.date.toString();
    }

    public IntegralNode getDeclarationType() {
        return this.declarationType;
    }

    public StringNode getBordereauNumber() {
        return this.bordereauNumber;
    }

    public ConstStringNode getBordereauNumberWithSourceInfo() {
        return ImportSending.getBordereauNumberWithSourceInfo(this.bordereauNumber.getStringValue(), this.receiptSource.getValue());
    }

    public static ConstStringNode getBordereauNumberWithSourceInfo(String bordereauNumber, ReceiptSource manualDownload) {
        String validatedBordereauNumber = bordereauNumber == null || bordereauNumber.isEmpty() ? "NA" : bordereauNumber;
        switch (manualDownload) {
            case file: {
                return new ConstStringNode(validatedBordereauNumber + " " + Services.getText(1583));
            }
            case download: {
                return new ConstStringNode(validatedBordereauNumber + " " + Services.getText(1584));
            }
        }
        return new ConstStringNode(validatedBordereauNumber);
    }

    public StringNode getOrderNumber() {
        return this.orderNumber;
    }

    public EnumNode<ReceiptSource> getReceiptSource() {
        return this.receiptSource;
    }

    public BooleanNode getArchive() {
        return this.archive;
    }

    public BooleanNode getStar() {
        return this.star;
    }

    public ImportSendingKey getKey() {
        return new ImportSendingKey(this.customsReferenceNumber.getValue(), this.getDateAsString());
    }

    public static enum ReceiptSource {
        bordereau,
        file,
        download;


        public boolean isBordereau() {
            return this == bordereau;
        }
    }
}

