/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.infra.annotation.listType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.RootNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.util.Check;

public final class ImportSendingList
extends ModelNode<ImportSendingList>
implements RootNode<ImportSendingList> {
    @listType(value=ImportSending.class)
    @mandatory
    private ListNode<ImportSending> importSendings;
    @mandatory
    private EdecDateNode date;

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    public boolean contains(String customsReferenceNumber) {
        return this.getImportSending(customsReferenceNumber) != null;
    }

    private ImportSending getImportSending(String customsReferenceNumber) {
        for (ImportSending current : this.getImportSendings()) {
            if (!current.getCustomsReferenceNumber().getValue().equals(customsReferenceNumber)) continue;
            return current;
        }
        return null;
    }

    public ImportSending getImportSending(ImportSendingKey key) {
        for (ImportSending current : this.getImportSendings()) {
            if (!key.equals(current.getKey())) continue;
            return current;
        }
        return null;
    }

    public void add(ImportSending importSending) {
        Check.assertEquals(this.getDate().getValue(), importSending.getDate().getValue());
        ImportSending existingImportSending = this.getImportSending(importSending.getKey());
        if (existingImportSending != null) {
            this.getImportSendings().remove(existingImportSending);
        }
        this.getImportSendings().add(importSending);
    }

    public ListNode<ImportSending> getImportSendings() {
        return this.importSendings;
    }

    public EdecDateNode getDate() {
        return this.date;
    }
}

