/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.index;

import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.indexhandling.IndexEntryBase;
import ch.transsoft.edec.model.infra.node.ConstStringNode;
import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.TableAdapter;
import ch.transsoft.edec.model.infra.node.TimestampNode;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.State;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class IndexEntry
extends IndexEntryBase<IndexEntry> {
    public static ITableAdapter[] tableConfig = new ITableAdapter[]{new TableAdapter("state", 522, State.class), new TableAdapter("creationDate", 523, DateNode.class), new TableAdapter("transmissionDate", 532, DateNode.class), new TableAdapter("acceptanceDate", 533, DateNode.class), new TableAdapter("traderDeclarationNumber", 524, DateNode.class), new TableAdapter("consignorName", 530, StringNode.class), new TableAdapter("traderReference", 525, StringNode.class), new TableAdapter("customsDeclarationNumber", 526, StringNode.class), new TableAdapter("consigneeName", 527, StringNode.class), new TableAdapter("deliveryName", 531, StringNode.class), new TableAdapter("consigneeCountry", 528, SelectionNode.class), new TableAdapter("carrierName", 529, StringNode.class)};
    @mandatory
    private State state;
    private String sendingId;
    private String traderDeclarationNumber;
    private String customsDeclarationNumber;
    private String traderReference;
    private Date creationDate;
    private Date transmissionDate;
    private Date acceptanceDate;
    private String consignorName;
    private String consigneeName;
    private String deliveryName;
    private String consigneeCountry;
    private String carrierName;
    private Long declarantNumber;

    public static ITableAdapter[] getTableConfig() {
        return tableConfig;
    }

    public IndexEntry() {
    }

    public IndexEntry(String sendingId) {
        Sending.checkSendingId(sendingId);
        this.sendingId = sendingId;
    }

    @Override
    public IndexEntry getCopy(ModelNode<?> parent) {
        IndexEntry result = new Builder(this.sendingId).setState(this.getState()).setTraderDeclarationNumber(this.traderDeclarationNumber).setTraderReference(this.traderReference).setCustomsDeclarationNumber(this.customsDeclarationNumber).setCreationDate(this.creationDate).setTransmissionDate(this.transmissionDate).setAcceptanceDate(this.acceptanceDate).setConsignorName(this.consignorName).setConsigneeName(this.consigneeName).setConsigneeCountry(this.consigneeCountry).setCarrierName(this.carrierName).setDeclarantNumber(this.declarantNumber).setDeliveryName(this.deliveryName).build();
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public void apply(IndexEntry other) {
        this.state.apply(other.getState());
        this.carrierName = other.carrierName;
        this.consigneeCountry = other.consigneeCountry;
        this.consigneeName = other.consigneeName;
        this.consignorName = other.consignorName;
        this.creationDate = other.creationDate;
        this.transmissionDate = other.transmissionDate;
        this.acceptanceDate = other.acceptanceDate;
        this.customsDeclarationNumber = other.customsDeclarationNumber;
        this.declarantNumber = other.declarantNumber;
        this.deliveryName = other.deliveryName;
        this.sendingId = other.sendingId;
        this.traderDeclarationNumber = other.traderDeclarationNumber;
        this.traderReference = other.traderReference;
    }

    @Override
    public void printField(Node parent, IXMLWriter writer, String tagName) throws Exception {
        Element element = writer.printModelNode(parent, this, tagName);
        this.state.printField(element, writer, "state");
        writer.printPrimitive((Node)element, this.carrierName, "carrierName");
        writer.printPrimitive((Node)element, this.consigneeCountry, "consigneeCountry");
        writer.printPrimitive((Node)element, this.consigneeName, "consigneeName");
        writer.printPrimitive((Node)element, this.consignorName, "consignorName");
        writer.printPrimitive((Node)element, this.customsDeclarationNumber, "customsDeclarationNumber");
        writer.printPrimitive((Node)element, this.declarantNumber, "declarantNumber");
        writer.printPrimitive((Node)element, this.deliveryName, "deliveryName");
        writer.printPrimitive((Node)element, this.sendingId, "sendingId");
        writer.printPrimitive((Node)element, this.traderDeclarationNumber, "traderDeclarationNumber");
        writer.printPrimitive((Node)element, this.traderReference, "traderReference");
        if (this.creationDate != null) {
            writer.printPrimitive((Node)element, this.creationDate.getTime(), "creationDate");
        }
        if (this.transmissionDate != null) {
            writer.printPrimitive((Node)element, this.transmissionDate.getTime(), "transmissionDate");
        }
        if (this.acceptanceDate != null) {
            writer.printPrimitive((Node)element, this.acceptanceDate.getTime(), "acceptanceDate");
        }
    }

    public State getState() {
        return this.state;
    }

    public TimestampNode getCreationDate() {
        return new TimestampNode(this.creationDate);
    }

    public boolean isOld() {
        if (!this.getTransmissionDate().isInitialized()) {
            return false;
        }
        return DateUtil.getAge(this.getTransmissionDate().getValue()) > 30;
    }

    public void setCreationDate(TimestampNode value) {
        this.creationDate = IndexEntry.valueOf(value);
    }

    public TimestampNode getTransmissionDate() {
        return new TimestampNode(this.transmissionDate);
    }

    public TimestampNode getAcceptanceDate() {
        return new TimestampNode(this.acceptanceDate);
    }

    public void setAcceptanceDate(TimestampNode value) {
        this.acceptanceDate = IndexEntry.valueOf(value);
    }

    public void setTransmissionDate(TimestampNode value) {
        this.transmissionDate = IndexEntry.valueOf(value);
    }

    public ConstStringNode getConsignorName() {
        return new ConstStringNode(this.consignorName);
    }

    public void setConsignorName(StringNode value) {
        this.consignorName = IndexEntry.valueOf(value);
    }

    public ConstStringNode getConsigneeName() {
        return new ConstStringNode(this.consigneeName);
    }

    public void setConsigneeName(StringNode value) {
        this.consigneeName = IndexEntry.valueOf(value);
    }

    public ConstStringNode getDeliveryName() {
        return new ConstStringNode(this.deliveryName);
    }

    public void setDeliveryName(StringNode value) {
        this.deliveryName = IndexEntry.valueOf(value);
    }

    public SelectionNode getConsigneeCountry() {
        return SelectionNode.create(Domain.isoCode, this.consigneeCountry);
    }

    public void setConsigneeCountry(SelectionNode country) {
        this.consigneeCountry = country.getValue().getKey();
    }

    public ConstStringNode getCarrierName() {
        return new ConstStringNode(this.carrierName);
    }

    public void setCarrierName(StringNode value) {
        this.carrierName = IndexEntry.valueOf(value);
    }

    public String getSendingId() {
        return this.sendingId;
    }

    @Override
    public String getId() {
        return this.getSendingId();
    }

    public ConstStringNode getCustomsDeclarationNumber() {
        return new ConstStringNode(this.customsDeclarationNumber);
    }

    public void setCustomsDeclarationNumber(StringNode value) {
        this.customsDeclarationNumber = IndexEntry.valueOf(value);
    }

    public ConstStringNode getTraderDeclarationNumber() {
        return new ConstStringNode(this.traderDeclarationNumber);
    }

    public void setTraderDeclarationNumber(StringNode value) {
        this.traderDeclarationNumber = IndexEntry.valueOf(value);
    }

    public ConstStringNode getTraderReference() {
        return new ConstStringNode(this.traderReference);
    }

    public void setTraderReference(StringNode value) {
        this.traderReference = IndexEntry.valueOf(value);
    }

    public IntegralNode getDeclarantNumber() {
        return new IntegralNode(this.declarantNumber);
    }

    public void setDeclarantNumber(IntegralNode value) {
        this.declarantNumber = IndexEntry.valueOf(value);
    }

    public int getYear() {
        return SendingUtil.getYear(this.getSendingId());
    }

    public String toString() {
        return this.getSendingId();
    }

    public OperatingMode getOperatingModeValue() {
        return this.getState().getOperatingMode();
    }

    public void setState(State state) {
        this.state = state;
    }

    private IndexEntry(Builder builder) {
        this(builder.sendingId);
        this.sendingId = builder.sendingId;
        this.setMandatory(builder.mandatory);
        builder.state.setParent(this);
        this.state = builder.state;
        this.traderDeclarationNumber = builder.traderDeclarationNumber;
        this.traderReference = builder.traderReference;
        this.customsDeclarationNumber = builder.customsDeclarationNumber;
        this.creationDate = builder.creationDate;
        this.transmissionDate = builder.transmissionDate;
        this.acceptanceDate = builder.acceptanceDate;
        this.consignorName = builder.consignorName;
        this.consigneeName = builder.consigneeName;
        this.consigneeCountry = builder.consigneeCountry;
        this.carrierName = builder.carrierName;
        this.declarantNumber = builder.declarantNumber;
        this.deliveryName = builder.deliveryName;
    }

    public static class Builder {
        private final String sendingId;
        private boolean mandatory;
        private State state;
        private String traderDeclarationNumber;
        private String customsDeclarationNumber;
        private String traderReference;
        private Date creationDate;
        private Date transmissionDate;
        private Date acceptanceDate;
        private String consignorName;
        private String consigneeName;
        private String deliveryName;
        private String consigneeCountry;
        private String carrierName;
        private Long declarantNumber;

        public Builder(String val) {
            this.sendingId = val;
        }

        public Builder setMandatory(boolean val) {
            this.mandatory = val;
            return this;
        }

        public Builder setState(State val) {
            this.state = val.getCopy((ModelNode)null);
            return this;
        }

        public Builder setTraderDeclarationNumber(StringNode val) {
            this.traderDeclarationNumber = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setTraderDeclarationNumber(String val) {
            this.traderDeclarationNumber = val;
            return this;
        }

        public Builder setTraderReference(StringNode val) {
            this.traderReference = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setTraderReference(String val) {
            this.traderReference = val;
            return this;
        }

        public Builder setCustomsDeclarationNumber(StringNode val) {
            this.customsDeclarationNumber = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setCustomsDeclarationNumber(String val) {
            this.customsDeclarationNumber = val;
            return this;
        }

        public Builder setCreationDate(TimestampNode val) {
            this.creationDate = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setCreationDate(Date val) {
            this.creationDate = val;
            return this;
        }

        public Builder setTransmissionDate(TimestampNode val) {
            this.transmissionDate = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setTransmissionDate(Date val) {
            this.transmissionDate = val;
            return this;
        }

        public Builder setAcceptanceDate(TimestampNode val) {
            this.acceptanceDate = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setAcceptanceDate(Date val) {
            this.acceptanceDate = val;
            return this;
        }

        public Builder setConsignorName(StringNode val) {
            this.consignorName = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setConsignorName(String val) {
            this.consignorName = val;
            return this;
        }

        public Builder setConsigneeName(StringNode val) {
            this.consigneeName = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setConsigneeName(String val) {
            this.consigneeName = val;
            return this;
        }

        public Builder setConsigneeCountry(SelectionNode country) {
            this.consigneeCountry = country.getValue().getKey();
            return this;
        }

        public Builder setConsigneeCountry(String val) {
            this.consigneeCountry = val;
            return this;
        }

        public Builder setCarrierName(StringNode val) {
            this.carrierName = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setCarrierName(String val) {
            this.carrierName = val;
            return this;
        }

        public Builder setDeclarantNumber(IntegralNode val) {
            this.declarantNumber = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setDeclarantNumber(Long val) {
            this.declarantNumber = val;
            return this;
        }

        public Builder setDeliveryName(StringNode val) {
            this.deliveryName = IndexEntry.valueOf(val);
            return this;
        }

        public Builder setDeliveryName(String val) {
            this.deliveryName = val;
            return this;
        }

        public IndexEntry build() {
            return new IndexEntry(this);
        }
    }
}

