/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra;

import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.text.ITextService;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AddressRenderer {
    private final List<String> strings = new ArrayList<String>();
    private final boolean isDemoVersion = !Services.get(IConfigService.class).hasLicenseForModuleExport();
    private static final Set<String> FULL_NAME_COUNTRIES = new HashSet<String>(Arrays.asList("US", "CL", "GB", "CA", "CN", "IR", "AU"));

    public void apply(StringBuilder result, String newLine) {
        for (int i2 = 0; i2 < this.strings.size(); ++i2) {
            if (i2 != 0) {
                result.append(newLine);
            }
            result.append(this.strings.get(i2));
        }
    }

    public void addLine(StringNode line) {
        if (!line.isInitialized()) {
            return;
        }
        this.addLine(line.getValue());
    }

    public void addLine(String line) {
        this.strings.add(line);
        this.patchDemoVersion();
    }

    public void addCountryAndCity(SelectionNode country, StringNode zip, StringNode city) {
        if (FULL_NAME_COUNTRIES.contains(country.getValue().getKey())) {
            this.strings.add(city.getValue() + ", " + zip.getValue());
            this.strings.add(country.getValue().getKey() + "  " + country.getValue().getDesc(ITextService.Language.en));
        } else {
            this.strings.add(country.getValue().getKey() + " " + zip.getValue() + " " + city.getValue());
        }
        this.patchDemoVersion();
    }

    public int getNumberOfLines() {
        return this.strings.size();
    }

    public void render(IRenderContext context, double x, double y, Fonts font) {
        context.drawString(x, y, font, Color.BLACK, this.strings.toArray(new String[0]));
    }

    private void patchDemoVersion() {
        if (!this.isDemoVersion) {
            return;
        }
        this.strings.clear();
        this.strings.add(Services.getText(135));
    }
}

