/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra;

import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.node.BinaryNode;
import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.model.infra.node.FileNode;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.infra.node.RootNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.TimestampNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.ReflectionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

public class XMLWriter
implements IXMLWriter {
    private static volatile DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private Document dom;

    public void write(File path, RootNode<?> obj, boolean createBackup) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.serialize(buffer, obj);
        if (buffer.size() == 0) {
            return;
        }
        if (createBackup) {
            this.createBackupBestEffort(path);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(buffer.toByteArray());
        FileOutputStream output = new FileOutputStream(path);
        FileUtil.copy((InputStream)input, output);
    }

    private void createBackupBestEffort(File path) {
        if (!path.exists() || path.length() == 0L || !this.fileIsValid(path)) {
            return;
        }
        File backupFile = FileUtil.addExtension(path, "backup");
        try {
            if (path.exists()) {
                FileUtil.copyFile(path, backupFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean fileIsValid(File path) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(path, new DefaultHandler());
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public void write(OutputStream output, RootNode<?> obj) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.serialize(buffer, obj);
        FileUtil.copy((InputStream)new ByteArrayInputStream(buffer.toByteArray()), output);
    }

    private void serialize(OutputStream output, RootNode<?> obj) throws Exception, TransformerFactoryConfigurationError {
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.dom = db.newDocument();
        this.printRoot(this.dom, obj);
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("encoding", "UTF-8");
        tr.transform(new DOMSource(this.dom), new StreamResult(output));
    }

    private void printRoot(Node parent, RootNode<?> obj) throws Exception {
        Element node = this.createElement(obj.getClass().getSimpleName());
        node.setAttribute("schemaVersion", Integer.toString(obj.getSchemaVersion()));
        parent.appendChild(node);
        ModelNode modelNode = (ModelNode)((Object)obj);
        this.printFields(node, modelNode);
    }

    @Override
    public void printObj(Node parent, INode<?> obj, String tagName) throws Exception {
        Element element = this.printModelNode(parent, obj, tagName);
        this.printFields(element, obj);
    }

    @Override
    public Element printModelNode(Node parent, INode<?> obj, String tagName) {
        Element element = this.createElement(tagName);
        parent.appendChild(element);
        this.setEnabled(element, (ModelNode)obj);
        return element;
    }

    private void setEnabled(Element element, NodeBase<?> node) {
        if (!node.isMandatory()) {
            element.setAttribute("enabled", Boolean.valueOf(node.isEnabled()).toString());
        }
    }

    private Element createElement(String name) {
        return this.dom.createElement(name);
    }

    private void printFields(Node parent, INode<?> obj) throws Exception {
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field)) continue;
            ((INode)field.get(obj)).printField(parent, this, field.getName());
        }
    }

    @Override
    public void printList(Node parent, ListNode<? extends INode<?>> list, String tagName) throws Exception {
        if (list.isEmpty()) {
            return;
        }
        Element listNode = this.createElement(tagName);
        this.setEnabled(listNode, list);
        parent.appendChild(listNode);
        this.listElements(listNode, list);
    }

    private void listElements(Node parent, ListNode<? extends INode<?>> list) throws Exception {
        for (INode<?> element : list) {
            element.printField(parent, this, element.getClass().getSimpleName());
        }
    }

    @Override
    public void printPrimitiveNode(Node parent, IPrimitive<?> primitive, String tagName) {
        if (!primitive.isInitialized()) {
            return;
        }
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.setTextContent(primitive.getStringValue());
    }

    @Override
    public void printBinaryNode(Node parent, BinaryNode primitive, String tagName) {
        if (!primitive.isInitialized()) {
            return;
        }
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.appendChild(this.dom.createCDATASection(primitive.getStringValue()));
    }

    @Override
    public void printEnum(Node parent, EnumNode<?> enumNode, String tagName) {
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.setTextContent(enumNode.getValueAsString());
    }

    @Override
    public void printSelectionNode(Node parent, SelectionNode selectionNode, String tagName) {
        if (!selectionNode.isInitialized()) {
            return;
        }
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.setTextContent(selectionNode.getValue().getKey());
    }

    @Override
    public void printEdecDate(Node parent, EdecDateNode dateNode, String tagName) {
        if (!dateNode.isInitialized()) {
            return;
        }
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.setTextContent(dateNode.getStringValue());
    }

    @Override
    public void printDate(Node parent, DateNode dateNode, String tagName) {
        if (!dateNode.isInitialized()) {
            return;
        }
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.setTextContent(DateUtil.formatEzvDate(dateNode.getValue()));
    }

    @Override
    public void printTimestampNode(Node parent, TimestampNode dateNode, String tagName) {
        if (!dateNode.isInitialized()) {
            return;
        }
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.setTextContent(Long.toString(dateNode.getValue().getTime()));
    }

    @Override
    public void printFileNode(Node parent, FileNode fileNode, String tagName) {
        if (!fileNode.isInitialized()) {
            return;
        }
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.setTextContent(fileNode.getStringValue());
    }

    @Override
    public void printPrimitive(Node parent, Object value, String tagName) {
        if (value == null) {
            return;
        }
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.setTextContent(value.toString());
    }

    @Override
    public void printPrimitive(Node parent, Date value, String tagName) {
        if (value == null) {
            return;
        }
        Element node = this.createElement(tagName);
        parent.appendChild(node);
        node.setTextContent(Long.toString(value.getTime()));
    }
}

