/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.node;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.LoggingContext;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.PrimitiveBase;
import ch.transsoft.edec.service.Services;
import java.math.BigInteger;
import org.w3c.dom.Node;

public class BooleanNode
extends PrimitiveBase<BooleanNode> {
    private boolean value;

    public BooleanNode() {
        this(false);
    }

    public BooleanNode(boolean value) {
        this.value = value;
    }

    @Override
    public String getStringValue() {
        return Boolean.toString(this.value);
    }

    public void setBooleanValue(boolean value, boolean dirty) {
        if (this.isSameValue(this.value, value)) {
            return;
        }
        this.value = value;
        this.fireEvent(dirty);
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        writer.printPrimitiveNode(node, this, tagName);
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public boolean getPrimitiveValue() {
        return this.value;
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        if (!str.equalsIgnoreCase("true") && !str.equalsIgnoreCase("false")) {
            context.log(this.getPath() + Services.getText(605) + str);
        }
        this.setValue(Boolean.parseBoolean(str), true);
    }

    public void setValue(Object value) {
        this.setValue(value, true);
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        this.setBooleanValue((Boolean)value, dirty);
    }

    @Override
    public BooleanNode getCopy(ModelNode<?> parent) {
        BooleanNode result = new BooleanNode(this.value);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public boolean isEquals(BooleanNode other) {
        return this.isSameValue(this.value, other.value);
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue(false, true);
    }

    public BigInteger asBigInt() {
        return this.getValue() != false ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public void cumulate(BooleanNode other) {
        if (other == null) {
            return;
        }
        if (!other.isInitialized()) {
            return;
        }
        if (other.getValue().booleanValue()) {
            this.setValue(true, true);
        }
    }
}

