/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.node;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.LoggingContext;
import ch.transsoft.edec.model.infra.node.INumberNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.PrimitiveBase;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.NumberUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.w3c.dom.Node;

public class DecimalNode
extends PrimitiveBase<DecimalNode>
implements INumberNode<DecimalNode> {
    private Double value;
    private int totalDigits;
    private int fractionDigits;
    private DecimalFormat format;

    public DecimalNode(int totalDigits, int fractionDigits) {
        this(null, totalDigits, fractionDigits);
    }

    public DecimalNode(Double value, int totalDigits, int fractionDigits) {
        this.setDigits(totalDigits, fractionDigits);
        this.setValue(value, true);
    }

    @Override
    public String getStringValue() {
        if (!this.isInitialized()) {
            return "";
        }
        return this.getFormat().format(this.getValue());
    }

    @Override
    public boolean isInitialized() {
        return this.value != null;
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        writer.printPrimitiveNode(node, this, tagName);
    }

    public String toString() {
        if (this.format == null || !this.isInitialized()) {
            return this.getStringValue();
        }
        return this.format.format(this.getValue());
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.setValue(value, true);
    }

    public void setValue(Number value, boolean dirty) {
        if (this.isSameValue(value)) {
            return;
        }
        if (value == null) {
            this.value = null;
        } else {
            try {
                this.value = this.getFormat().parse(this.getFormat().format(value)).doubleValue();
            }
            catch (ParseException e2) {
                this.value = null;
            }
        }
        this.fireEvent(dirty);
    }

    private boolean isSameValue(Number other) {
        if (this.value == null && other == null) {
            return true;
        }
        if (this.value == null || other == null) {
            return false;
        }
        return this.value.doubleValue() == other.doubleValue();
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        String trimmed2 = str.trim().replace("\u2019", "").replace(",", "");
        if (trimmed2.isEmpty()) {
            return;
        }
        try {
            this.setValue(this.getFormat().parse(trimmed2), true);
        }
        catch (ParseException e2) {
            context.log(this.getPath() + Services.getText(607) + str);
        }
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        if (value instanceof String) {
            try {
                this.setValue(this.getFormat().parse((String)value), dirty);
            }
            catch (Exception e2) {
                this.setValue(null, dirty);
            }
            return;
        }
        this.setValue((Number)value, dirty);
    }

    public int getTotalDigits() {
        return this.totalDigits;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    private void setDigits(int totalDigits, int fractionDigits) {
        this.fractionDigits = fractionDigits;
        this.totalDigits = totalDigits;
        this.format = NumberUtil.createNumberFormat();
        this.format.setMaximumFractionDigits(fractionDigits);
        this.format.setMinimumFractionDigits(fractionDigits);
    }

    @Override
    public DecimalNode getCopy(ModelNode<?> parent) {
        DecimalNode result = new DecimalNode(this.value, this.totalDigits, this.fractionDigits);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public boolean isEquals(DecimalNode other) {
        return this.isSameValue(this.value, other.value);
    }

    public BigDecimal asBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    public NumberFormat getFormat() {
        Check.assertNotNull(this.format);
        return this.format;
    }

    public void add(DecimalNode summand) {
        if (summand == null) {
            return;
        }
        if (!summand.isInitialized()) {
            return;
        }
        if (!this.isInitialized()) {
            this.setValue(summand.value, false);
            return;
        }
        this.setValue(this.getValue() + summand.getValue(), false);
    }

    @Override
    public void cumulate(DecimalNode summand) {
        if (summand == null) {
            return;
        }
        this.add(summand);
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue(null, true);
    }

    @Override
    public Double getAsNumber() {
        return this.value;
    }
}

