/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.node;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.LoggingContext;
import ch.transsoft.edec.model.infra.node.INumberNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.PrimitiveBase;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.NumberUtil;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import org.w3c.dom.Node;

public final class IntegralNode
extends PrimitiveBase<IntegralNode>
implements INumberNode<IntegralNode> {
    private Long value;
    private int maxNumberOfDigits = Integer.MAX_VALUE;
    private NumberFormat format;

    public IntegralNode() {
    }

    public IntegralNode(Long value) {
        this.value = value;
    }

    @Override
    public String getStringValue() {
        if (!this.isInitialized()) {
            return "";
        }
        return this.value.toString();
    }

    public void setValue(Long value) {
        this.setValue(value, true);
    }

    public void setValue(Long value, boolean dirty) {
        if (this.isSameValue(this.value, value)) {
            return;
        }
        this.value = value;
        this.fireEvent(dirty);
    }

    public void add(IntegralNode summand) {
        if (summand == null) {
            return;
        }
        if (!summand.isInitialized()) {
            return;
        }
        if (!this.isInitialized()) {
            this.setValue(summand.value, false);
            return;
        }
        this.setValue(this.getValue() + summand.getValue(), false);
    }

    @Override
    public boolean isInitialized() {
        return this.value != null;
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        writer.printPrimitiveNode(node, this, tagName);
    }

    public String toString() {
        if (this.value == null || this.format == null) {
            return this.getStringValue();
        }
        return this.format.format(this.value);
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public int getIntValue() {
        Check.assertTrue(this.isInitialized(), "Integral not initialized");
        return this.getValue().intValue();
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        String trimmed2 = str.trim().replace("\u2019", "").replace(",", "");
        if (trimmed2.isEmpty()) {
            return;
        }
        try {
            this.setValue(this.getFormat().parse(trimmed2), true);
        }
        catch (ParseException e2) {
            context.log(this.getPath() + Services.getText(608) + str);
        }
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        this.setValue((Long)value, dirty);
    }

    public int getMaxDigits() {
        return this.maxNumberOfDigits;
    }

    public void setMaxNumberOfDigits(int digits) {
        this.maxNumberOfDigits = digits;
        this.format = NumberUtil.createIntegerFormat();
        this.format.setMaximumIntegerDigits(digits);
    }

    @Override
    public IntegralNode getCopy(ModelNode<?> parent) {
        IntegralNode result = new IntegralNode(this.value);
        result.setMaxNumberOfDigits(this.maxNumberOfDigits);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public boolean isEquals(IntegralNode other) {
        return this.isSameValue(this.value, other.value);
    }

    public BigInteger asBigInt() {
        return BigInteger.valueOf(this.getValue());
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue(null, true);
    }

    public void setValueSilent(Long value) {
        this.value = value;
    }

    @Override
    public void cumulate(IntegralNode summand) {
        if (summand == null) {
            return;
        }
        if (!summand.isInitialized()) {
            return;
        }
        if (!this.isInitialized()) {
            this.setValue(summand.value, true);
            return;
        }
        this.setValue(this.getValue() + summand.getValue(), false);
    }

    @Override
    public Long getAsNumber() {
        return this.value;
    }
}

