/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.node;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.event.DataChanged;
import ch.transsoft.edec.model.infra.event.IChangeInfo;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.service.validate.ErrorMarker;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.util.HashMap;
import java.util.Map;

public abstract class NodeBase<T extends NodeBase<T>>
implements INode<T> {
    private ErrorMarker errorMarker;
    private int errorCount = 0;
    private String fieldName;
    private Boolean mandatory;
    private ModelNode<?> parent;
    private boolean enabled = false;
    private boolean readValue = true;
    private ListenerList<IErrorListener> errorListeners;
    private Map<String, ListenerList<IChangeListener>> fieldListenerMap;
    private ListenerList<IChangeListener> listeners;

    public void setMandatory(Boolean mandatory2) {
        Check.assertNull(this.mandatory);
        this.mandatory = mandatory2;
    }

    @Override
    public boolean isMandatory() {
        Check.assertNotNull(this.mandatory, "field mandatory is null: " + this.getClass().getSimpleName());
        return this.mandatory;
    }

    @Override
    public ModelNode<?> getParent() {
        return this.parent;
    }

    public void setParent(ModelNode<?> parent) {
        this.parent = parent;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void fireEvent(boolean dirty) {
        this.fireEvent(dirty ? DataChanged.DIRTY_CHANGE : DataChanged.NON_DIRTY_CHANGE);
    }

    public void fireEvent() {
        this.fireEvent(true);
    }

    public void fireEvent(IChangeInfo info) {
        this.fireEvent(this, info);
    }

    private void fireEvent(INode<?> source, IChangeInfo info) {
        this.notifyListeners(source, info);
        ModelNode<?> parent = this.getParent();
        if (parent != null) {
            parent.fireEvent(source, info);
        }
    }

    private void notifyListeners(INode<?> source, IChangeInfo info) {
        this.notifyChangeListeners(source, info);
        this.notifyFieldListeners(source, info);
    }

    private void notifyFieldListeners(INode<?> source, IChangeInfo info) {
        if (this.fieldListenerMap == null) {
            return;
        }
        ListenerList<IChangeListener> fieldListeners = this.fieldListenerMap.get(source.getFieldName());
        if (fieldListeners == null) {
            return;
        }
        for (IChangeListener listener : fieldListeners) {
            listener.changed(source, info);
        }
    }

    private void notifyChangeListeners(INode<?> source, IChangeInfo info) {
        if (this.listeners == null) {
            return;
        }
        for (IChangeListener listener : this.listeners) {
            listener.changed(source, info);
        }
    }

    public IDisposable addChangeListener(IChangeListener listener) {
        return this.getListeners().add(listener);
    }

    private ListenerList<IChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        return this.listeners;
    }

    public IDisposable addFieldListener(String source, IChangeListener listener) {
        ListenerList<IChangeListener> listeners = this.getFieldListenerMap().get(source);
        if (listeners == null) {
            listeners = new ListenerList();
            this.getFieldListenerMap().put(source, listeners);
        }
        return listeners.add(listener);
    }

    private Map<String, ListenerList<IChangeListener>> getFieldListenerMap() {
        if (this.fieldListenerMap == null) {
            this.fieldListenerMap = new HashMap<String, ListenerList<IChangeListener>>();
        }
        return this.fieldListenerMap;
    }

    protected boolean isSameValue(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public void completeCopy(NodeBase<?> result, ModelNode<?> parent) {
        result.parent = parent;
        result.mandatory = this.mandatory;
        result.fieldName = this.fieldName;
        result.enabled = this.enabled;
        result.readValue = this.readValue;
    }

    @Override
    public String getPath() {
        if (this.isParent()) {
            return this.getFieldName();
        }
        String parentPath = this.getParent().getPath();
        if (parentPath == null) {
            return this.getFieldName();
        }
        return this.getParent().getPath() + "/" + this.getFieldName();
    }

    @Override
    public void setError(ErrorMarker errorMarker) {
        if (this.errorMarker != null) {
            return;
        }
        this.errorMarker = errorMarker;
        this.notifyErrorChanged();
        this.incrementErrorCount(errorMarker);
    }

    private boolean isParent() {
        return this.getParent() == null;
    }

    @Override
    public void removeError() {
        if (this.errorMarker == null) {
            return;
        }
        this.errorMarker = null;
        this.notifyErrorChanged();
        this.decrementErrorCount();
    }

    public void decrementErrorCount() {
        this.decrementErrorCount(1);
    }

    public void decrementErrorCount(int amount) {
        this.errorCount -= amount;
        Check.assertTrue(this.errorCount >= 0, "invalid errorCount", this.errorCount, ". Decremented by ", amount);
        if (this.errorCount == 0) {
            this.errorMarker = null;
        }
        this.notifyErrorChanged();
        ModelNode<?> parent = this.getParent();
        if (parent != null) {
            parent.decrementErrorCount(amount);
        }
    }

    private void incrementErrorCount(ErrorMarker errorMarker) {
        if (this.errorMarker == null) {
            this.errorMarker = errorMarker;
        }
        ++this.errorCount;
        this.notifyErrorChanged();
        ModelNode<?> parent = this.getParent();
        if (parent != null) {
            parent.incrementErrorCount(errorMarker);
        }
    }

    public IDisposable addErrorListener(IErrorListener errorListener) {
        return this.getErrorListeners().add(errorListener);
    }

    private ListenerList<IErrorListener> getErrorListeners() {
        if (this.errorListeners == null) {
            this.errorListeners = new ListenerList();
        }
        return this.errorListeners;
    }

    private void notifyErrorChanged() {
        if (this.errorListeners == null) {
            return;
        }
        ErrorInfo info = this.getErrorInfo();
        for (IErrorListener listener : this.errorListeners) {
            listener.change(info);
        }
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return new ErrorInfo(this.errorCount, this.errorMarker == null ? null : this.errorMarker.getMessage());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.fireEvent(DataChanged.DIRTY_CHANGE);
    }

    @Override
    public boolean isReadValue() {
        return this.readValue;
    }

    public void setReadValue(boolean readValue) {
        this.readValue = readValue;
    }

    public void postConstructionNotification() {
    }

    @Override
    public boolean isFieldName(String fieldName) {
        if (this.getFieldName() == null) {
            return false;
        }
        return this.getFieldName().equals(fieldName);
    }
}

