/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.node;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.LoggingContext;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.PrimitiveBase;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.IDomainData;
import ch.transsoft.edec.service.masterdataezv.IMasterDataEZVService;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.util.Check;
import java.math.BigInteger;
import org.w3c.dom.Node;

public final class SelectionNode
extends PrimitiveBase<SelectionNode> {
    private final IDomainData domainData;
    private DomainValue value;

    public static SelectionNode create(Domain domain, String key) {
        IDomainData data = Services.get(IMasterDataEZVService.class).getDomainData(domain, false);
        return new SelectionNode(data, data.get(key));
    }

    public SelectionNode(IDomainData domainData) {
        this(domainData, DomainValue.getUninitialized());
    }

    public SelectionNode(IDomainData domainData, DomainValue currentValue) {
        Check.assertNotNull(domainData);
        this.domainData = domainData;
        this.value = currentValue;
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        writer.printSelectionNode(node, this, tagName);
    }

    @Override
    public boolean isInitialized() {
        return this.value.isInitialized();
    }

    public IDomainData getDomainData() {
        return this.domainData;
    }

    public void setCurrentValue(DomainValue item, boolean dirty) {
        if (item.equals(this.getValue())) {
            return;
        }
        this.value = item;
        this.fireEvent(dirty);
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public String getStringValue() {
        return this.getValue().getKey() + "  " + this.getValue().getDe();
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        DomainValue currentValue = this.domainData.get(str);
        if (currentValue == null) {
            currentValue = DomainValue.createUnknown(str);
            context.log(this.getPath() + Services.getText(609) + str);
        }
        this.setValue(currentValue, true);
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        if (value == null) {
            value = DomainValue.getUninitialized();
        }
        this.setCurrentValue((DomainValue)value, dirty);
    }

    public void setValue(String key) {
        this.setCurrentValue(this.getDomainData().get(key), true);
    }

    @Override
    public SelectionNode getCopy(ModelNode<?> parent) {
        SelectionNode result = new SelectionNode(this.domainData, this.value);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public DomainValue getValue() {
        return this.value;
    }

    @Override
    public boolean isEquals(SelectionNode other) {
        return this.isSameValue(this.value, other.value);
    }

    public BigInteger asBigInt() {
        return new BigInteger(this.getValue().getKey());
    }

    public int asInt() {
        return this.getValue().getKeyAsInt();
    }

    public String asString() {
        return this.getValue().getKey();
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    public boolean in(String[] values) {
        if (!this.isInitialized()) {
            return false;
        }
        String currentValue = this.getValue().getKey();
        for (String s : values) {
            if (!s.equals(currentValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.setValue(DomainValue.getUninitialized(), true);
    }

    public boolean isValueInDomainData() {
        return this.getDomainData().containsValue(this.getValue().getKey());
    }

    @Override
    public void cumulate(SelectionNode other) {
    }
}

