/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.node;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.LoggingContext;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.PrimitiveBase;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.util.DateUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public final class TimestampNode
extends PrimitiveBase<TimestampNode>
implements Comparable<TimestampNode> {
    private Date value;

    public TimestampNode() {
        this(null);
    }

    public TimestampNode(Date date) {
        this.value = date;
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        writer.printTimestampNode(node, this, tagName);
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        try {
            this.setValue(new Date(Long.parseLong(str)), true);
        }
        catch (NumberFormatException e2) {
            this.setValue(null, true);
            context.log(this.getPath() + Services.getText(612) + str);
        }
    }

    public void setValue(Date value, boolean dirty) {
        if (this.isSameValue(this.value, value)) {
            return;
        }
        this.value = value;
        this.fireEvent(dirty);
    }

    @Override
    public boolean isInitialized() {
        return this.value != null;
    }

    @Override
    public Date getValue() {
        return this.value;
    }

    public String getEzvDate() {
        return DateUtil.formatEzvDate(this.value);
    }

    public String getDate() {
        return DateUtil.formatDate(this.value);
    }

    @Override
    public TimestampNode getCopy(ModelNode<?> parent) {
        TimestampNode result = new TimestampNode(this.value);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public boolean isEquals(TimestampNode other) {
        return this.isSameValue(this.value, other.value);
    }

    @Override
    public String getStringValue() {
        if (!this.isInitialized()) {
            return "";
        }
        return DateUtil.getDateFormat().format(this.value);
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        this.setValue((Date)value, dirty);
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue(null, true);
    }

    @Override
    public int compareTo(@NotNull TimestampNode o) {
        if (!this.isInitialized() && !o.isInitialized()) {
            return 0;
        }
        if (this.isInitialized() && !o.isInitialized()) {
            return 1;
        }
        if (!this.isInitialized() && o.isInitialized()) {
            return -1;
        }
        return this.value.compareTo(o.getValue());
    }

    @Override
    public void cumulate(TimestampNode other) {
    }
}

