/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.infra.InjectionSpec;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.listType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.event.CustomsItemListCreated;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.RootNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.TimestampNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.State;
import ch.transsoft.edec.model.sending.forms.Forms;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.model.sending.goodsdeclaration.GoodsDeclaration;
import ch.transsoft.edec.model.sending.history.HistoryEntry;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.SendingUtil;
import java.util.regex.Pattern;

public final class Sending
extends ModelNode<Sending>
implements RootNode<Sending> {
    private transient boolean pendingChanges = false;
    private transient String sendingId;
    @defaultValue(value="0")
    private IntegralNode version;
    private StringNode expoVitVersion;
    @mandatory
    private State state;
    @defaultValue(value="false")
    private BooleanNode archive;
    @mandatory
    @defaultValue(value="now")
    private TimestampNode creationDate;
    private TimestampNode transmissionDate;
    private TimestampNode acceptanceDate;
    @mandatory
    private GoodsDeclaration goodsDeclaration;
    @mandatory
    private Forms forms;
    @mandatory
    private ItemList itemList;
    @mandatory
    private ItemList customsItemList;
    @mandatory
    @listType(value=HistoryEntry.class)
    private ListNode<HistoryEntry> history;

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    @Override
    public void postConstructionNotification() {
        this.addDirtyListener();
    }

    @Override
    public Sending getCopy(ModelNode<?> parent) {
        Sending result = (Sending)super.getCopy((ModelNode)parent);
        result.setSendingId(this.getSendingId());
        return result;
    }

    public void activateBusinessLogicListeners() {
        this.addIncotermsListener();
        this.transportModeListener();
        this.getItemList().addAdjustTraderItemIdListener();
        this.addEur1ActivationListener();
    }

    private void addEur1ActivationListener() {
        this.getForms().getEur1().getEur1Number().addChangeListener((source, info) -> {
            if (this.getForms().getEur1().isEnabled()) {
                return;
            }
            this.getForms().getEur1().setEnabled(true);
        });
        this.getForms().getEur1().addChangeListener((source, info) -> {
            if (source != this.getForms().getEur1()) {
                return;
            }
            if (!this.getForms().getEur1().isEnabled()) {
                return;
            }
            if (!this.getState().hasAl()) {
                return;
            }
            DialogUtil.showWarningDialog(Services.getText(634), Services.getText(635));
        });
    }

    private void transportModeListener() {
        this.getGoodsDeclaration().getTransportMeans().getTransportMode().addChangeListener((source, info) -> {
            SelectionNode transportMode = (SelectionNode)source;
            IntegralNode forwarding = this.getForms().getSpedi().getForwarding();
            if (!transportMode.isInitialized()) {
                return;
            }
            int value = transportMode.asInt();
            switch (value) {
                case 2: {
                    forwarding.setValue(1L);
                    break;
                }
                case 3: {
                    forwarding.setValue(0L);
                    break;
                }
                case 4: {
                    forwarding.setValue(3L);
                    break;
                }
                case 5: {
                    forwarding.setValue(2L);
                    break;
                }
                case 8: {
                    forwarding.setValue(4L);
                    break;
                }
                default: {
                    forwarding.clear();
                }
            }
        });
    }

    private void addIncotermsListener() {
        this.getGoodsDeclaration().getBusiness().getIncoterms().addChangeListener((source, info) -> {
            SelectionNode incoterms = (SelectionNode)source;
            IntegralNode cleared = this.getForms().getSpedi().getCleared();
            String value = incoterms.getValue().getKey();
            if (value.equals("DDP")) {
                cleared.setValue(0L);
            } else if (value.equals("DDU")) {
                cleared.setValue(1L);
            }
        });
    }

    private void addDirtyListener() {
        this.addChangeListener((source, info) -> {
            if (source == this) {
                return;
            }
            if (!info.isDirty()) {
                return;
            }
            this.pendingChanges = true;
        });
    }

    public void applyDefaults() {
        InjectionSpec spec = new InjectionSpec(false, false, false);
        this.getForms().getBill().getCity().inject(this.getGoodsDeclaration().getConsignor().getCity(), spec);
        this.getForms().getDeliveryNote().getCity().inject(this.getGoodsDeclaration().getConsignor().getCity(), spec);
        this.getForms().getSpedi().getFooterLocation().inject(this.getGoodsDeclaration().getConsignor().getZipAndCity(), spec);
        this.getForms().getCmr().getF4City().inject(this.getGoodsDeclaration().getConsignor().getZipAndCity(), spec);
        this.getForms().getCmr().getF4Country().inject(this.getGoodsDeclaration().getConsignor().getCountry().getValue().getDescAsStringNode(), spec);
        if (this.getGoodsDeclaration().getConsignor().getCity().isInitialized()) {
            this.getForms().getBg().getPlaceAndDate().inject(this.getGoodsDeclaration().getConsignor().getPlaceAndDate(), spec);
        }
    }

    public void cleanForSavingSendingAsTempate() {
        this.getGoodsDeclaration().cleanDeclarant();
    }

    public void cleanForSaveTemplate() {
        this.clearState();
        this.getArchive().clear();
        this.sendingId = null;
        this.getHistory().clear();
        this.getCreationDate().clear();
        this.getTransmissionDate().clear();
        this.getAcceptanceDate().clear();
        this.getGoodsDeclaration().getCustomsDeclarationNumber().clear();
        this.getGoodsDeclaration().getTraderDeclarationNumber().clear();
        this.getGoodsDeclaration().getCorrectionCode().setValue("1");
        this.getGoodsDeclaration().getCorrectionReason().clear();
        this.getForms().getEur1().getDate().clear();
        this.getForms().getEur1().getEur1Number().clear();
        this.getForms().getSpedi().getFooterDate().clear();
        this.getForms().getBill().getDate().clear();
        this.getForms().getBill().getDateBottom().clear();
        this.getForms().getDeliveryNote().getDate().clear();
        this.getForms().getCmr().getF4Date().clear();
        this.getForms().getCmr().getF21Date().clear();
    }

    public String getConsignorEMail() {
        StringNode p = this.getGoodsDeclaration().getDeclarant().getEmail();
        if (p.isInitialized()) {
            return p.getValue();
        }
        return this.getGoodsDeclaration().getConsignor().getEmail().getValue();
    }

    public String getPhone() {
        StringNode p = this.getGoodsDeclaration().getDeclarant().getPhone();
        if (p.isInitialized()) {
            return p.getValue();
        }
        return this.getGoodsDeclaration().getConsignor().getPhone().getValue();
    }

    public ItemList getItemList() {
        return this.itemList;
    }

    public ItemList getCustomsItemList() {
        return this.customsItemList;
    }

    public ItemList getItemListForForm(FormName form) {
        switch (form) {
            case spedi: 
            case eur1: 
            case uz: 
            case bg: 
            case emergency: 
            case cmr: 
            case itemListForm: {
                return this.getCustomsItemListIfPresent();
            }
            case bill: 
            case deliveryNote: {
                return this.getItemList();
            }
        }
        throw Check.fail("Unknown formname: " + form);
    }

    public ItemList getCustomsItemListIfPresent() {
        return this.hasCustomsItemList() ? this.getCustomsItemList() : this.getItemList();
    }

    public State getState() {
        return this.state;
    }

    public GoodsDeclaration getGoodsDeclaration() {
        return this.goodsDeclaration;
    }

    public TimestampNode getCreationDate() {
        return this.creationDate;
    }

    public TimestampNode getTransmissionDate() {
        return this.transmissionDate;
    }

    public TimestampNode getAcceptanceDate() {
        return this.acceptanceDate;
    }

    public String getSendingId() {
        return this.sendingId;
    }

    public StringNode getIncotermsDescForBill() {
        IntegralNode taxed;
        DomainValue value = this.getGoodsDeclaration().getBusiness().getIncoterms().getValue();
        if (!value.isInitialized()) {
            return new StringNode("");
        }
        ITextService.Language formLanguage = this.getBillFormLanguage();
        Object addition = "";
        if (value.getKey().equals("DDP") && (taxed = this.getForms().getSpedi().getTaxed()).isInitialized() && taxed.getValue() == 1L) {
            addition = ", " + Services.get(ITextService.class).getText(formLanguage, 769);
        }
        Object location = "";
        if (this.getForms().getSpedi().getIncotermsLocation().isInitialized()) {
            location = ",  " + this.getForms().getSpedi().getIncotermsLocation().getValue();
        }
        return new StringNode(value.getDesc(formLanguage) + (String)location + (String)addition);
    }

    public ITextService.Language getBillFormLanguage() {
        if (this.getForms().getBill().getDescriptionInEnglish().getValue().booleanValue()) {
            return ITextService.Language.en;
        }
        return Services.get(ITextService.class).getCurrentLanguage();
    }

    public void setSendingId(String sendingId) {
        if (sendingId != null) {
            Sending.checkSendingId(sendingId);
            if (!this.getForms().getCmr().getSequenceNumber().isInitialized()) {
                this.getForms().getCmr().getSequenceNumber().setValue(sendingId.replace("-", ""));
            }
        }
        this.sendingId = sendingId;
    }

    public static void checkSendingId(String sendingId) {
        Pattern sendingIdPattern = Pattern.compile("\\d{4}-.*");
        Check.assertNotNull(sendingId);
        Check.assertTrue(sendingIdPattern.matcher(sendingId).matches(), "Invalid SendingId: " + sendingId);
    }

    public IndexEntry getIndexEntry() {
        IndexEntry.Builder builder = new IndexEntry.Builder(this.getSendingId()).setMandatory(false).setState(this.getState()).setTraderDeclarationNumber(this.getGoodsDeclaration().getTraderDeclarationNumber()).setTraderReference(this.getGoodsDeclaration().getTraderReference()).setCustomsDeclarationNumber(this.getGoodsDeclaration().getCustomsDeclarationNumber()).setCreationDate(this.getCreationDate()).setTransmissionDate(this.getTransmissionDate()).setAcceptanceDate(this.getAcceptanceDate()).setConsignorName(this.getGoodsDeclaration().getConsignor().getName()).setConsigneeName(this.getGoodsDeclaration().getConsignee().getName()).setConsigneeCountry(this.getGoodsDeclaration().getConsignee().getCountry()).setCarrierName(this.getGoodsDeclaration().getCarrier().getName()).setDeclarantNumber(this.getGoodsDeclaration().getDeclarant().getDeclarantNumber());
        if (this.getGoodsDeclaration().getDelivery().isEnabled()) {
            builder.setDeliveryName(this.getGoodsDeclaration().getDelivery().getName());
        }
        return builder.build();
    }

    public IntegralNode getVersion() {
        return this.version;
    }

    public StringNode getExpoVitVersion() {
        return this.expoVitVersion;
    }

    public String getTraderDeclarationNumber() {
        return this.getGoodsDeclaration().getTraderDeclarationNumber().getStringValue();
    }

    public String getCustomsDeclarationNumber() {
        return this.getGoodsDeclaration().getCustomsDeclarationNumber().getStringValue();
    }

    public void setAlComplete() {
        this.getState().setAlComplete();
    }

    public void evvReceived() {
        this.getState().evvReceived();
    }

    public boolean hasPendingChanges() {
        return this.pendingChanges;
    }

    public void clearPendingChanges() {
        this.pendingChanges = false;
        this.fireEvent();
    }

    public boolean isPendingChanges() {
        return this.pendingChanges;
    }

    public Forms getForms() {
        return this.forms;
    }

    public BooleanNode getArchive() {
        return this.archive;
    }

    public boolean isSending(IndexEntry indexEntry) {
        if (this.getSendingId() == null) {
            return false;
        }
        return this.getSendingId().equals(indexEntry.getSendingId());
    }

    public int getYear() {
        Check.assertNotNull(this.getSendingId());
        return SendingUtil.getYear(this.getSendingId());
    }

    public ListNode<HistoryEntry> getHistory() {
        return this.history;
    }

    public void clearState() {
        this.state = NodeFactory.create(State.class);
    }

    public OperatingMode getOperatingModeValue() {
        return this.getState().getOperatingMode();
    }

    public void setStatus(int status) {
        this.getState().setStatus(status);
        this.addHistoryEntry("Status set to " + status);
    }

    public void setCustomsDeclarationVersion(long version) {
        this.getGoodsDeclaration().getCustomsDeclarationVersion().setValue(version);
        this.addHistoryEntry("CustomsDeclarationVersion set to " + version);
    }

    public void addHistoryEntry(String message) {
        HistoryEntry hist = NodeFactory.create(HistoryEntry.class);
        String user = Services.get(IConfigService.class).getUserName();
        hist.getUser().setValue(user);
        hist.getMessage().setValue(message);
        this.getHistory().add(hist);
    }

    public Address getDeliveryAddress() {
        Address delivery = this.getGoodsDeclaration().getDelivery();
        return delivery.isEnabled() ? delivery : this.getGoodsDeclaration().getConsignee();
    }

    public void compact() {
        this.customsItemList = (ItemList)this.itemList.getCopy((ModelNode)this);
        this.customsItemList.setFieldName("customsItemList");
        this.customsItemList.compact();
        this.customsItemList.addAdjustTraderItemIdListener();
        this.fireEvent(new CustomsItemListCreated());
    }

    public boolean hasCustomsItemList() {
        return !this.getCustomsItemList().isEmpty();
    }

    public void setCurrencyRate(String currency, Number currencyRate) {
        Check.assertNotNull(currency);
        Check.assertNotNull(currencyRate);
        if ("CHF".equals(currency)) {
            return;
        }
        this.itemList.setCurrencyRate(currency, currencyRate);
        this.customsItemList.setCurrencyRate(currency, currencyRate);
    }

    public boolean hasSendingId() {
        return this.getSendingId() != null && !this.getSendingId().isEmpty();
    }

    public static enum FormName {
        spedi,
        eur1,
        uz,
        bg,
        bill,
        deliveryNote,
        emergency,
        cmr,
        itemListForm;

    }
}

