/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.forms;

import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.annotation.maxlen;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.forms.FormBase;

public final class Bill
extends FormBase<Bill> {
    private StringNode variantId;
    private StringNode textBesideConsignee;
    @defaultValue(value="0")
    @mandatory
    private IntegralNode type;
    @maxlen(value=40)
    @mandatory
    private StringNode city;
    @mandatory
    @defaultValue(value="now")
    private DateNode date;
    private StringNode freeTextGoods;
    @defaultValue(value="true")
    private BooleanNode showWeights;
    private StringNode freeTextBottom;
    private StringNode freeTextBottomLarge;
    private StringNode freeTextBottomLine;
    @defaultValue(value="1")
    private IntegralNode footer;
    private BooleanNode textEnglish;
    @Deprecated
    private BooleanNode showOrigin;
    private StringNode countryOfOrigin;
    @maxlen(value=50)
    @defaultValue(value="schweizerische")
    private StringNode perfCountryOfOrigin;
    @maxlen(value=40)
    private StringNode nameBottom;
    @defaultValue(value="now")
    private DateNode dateBottom;
    @maxlen(value=40)
    private StringNode billNumber;
    private StringNode freeTextInGoodsItemList;
    @defaultValue(value="1")
    @mandatory
    private IntegralNode cumulationApplied;
    @maxlen(value=50)
    private StringNode cumulationCountry;
    private BooleanNode showAdditianalUnit;
    private BooleanNode descriptionInEnglish;
    @defaultValue(value="false")
    private BooleanNode idInsteadMark;
    @defaultValue(value="true")
    private BooleanNode declarantAsName;

    @Override
    public StringNode getVariantId() {
        return this.variantId;
    }

    @Override
    public BooleanNode getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @Override
    public boolean isFormEnglish() {
        return this.descriptionInEnglish.getValue();
    }

    public BooleanNode getIdInsteadMark() {
        return this.idInsteadMark;
    }

    public StringNode getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public StringNode getNameBottom() {
        return this.nameBottom;
    }

    public DateNode getDateBottom() {
        return this.dateBottom;
    }

    public StringNode getTextBesideConsignee() {
        return this.textBesideConsignee;
    }

    public IntegralNode getType() {
        return this.type;
    }

    public StringNode getCity() {
        return this.city;
    }

    public DateNode getDate() {
        return this.date;
    }

    public StringNode getFreeTextGoods() {
        return this.freeTextGoods;
    }

    public BooleanNode getShowWeights() {
        return this.showWeights;
    }

    public StringNode getFreeTextBottomLarge() {
        return this.freeTextBottomLarge;
    }

    public StringNode getFreeTextBottom() {
        return this.freeTextBottom;
    }

    public StringNode getFreeTextBottomLine() {
        return this.freeTextBottomLine;
    }

    public IntegralNode getFooter() {
        return this.footer;
    }

    public boolean isUrsprungsland() {
        if (!this.getFooter().isInitialized()) {
            return false;
        }
        return this.getFooter().getValue() == 0L;
    }

    public boolean isPrefEUR_1() {
        if (!this.getFooter().isInitialized()) {
            return false;
        }
        return this.getFooter().getValue() == 1L;
    }

    public boolean isPrefEUR_MED() {
        if (!this.getFooter().isInitialized()) {
            return false;
        }
        return this.getFooter().getValue() == 2L;
    }

    public BooleanNode getTextEnglish() {
        return this.textEnglish;
    }

    @Deprecated
    public BooleanNode getShowOrigin() {
        return this.showOrigin;
    }

    public StringNode getPerfCountryOfOrigin() {
        return this.perfCountryOfOrigin;
    }

    public StringNode getBillNumber() {
        return this.billNumber;
    }

    public StringNode getFreeTextInGoodsItemList() {
        return this.freeTextInGoodsItemList;
    }

    public IntegralNode getCumulationApplied() {
        return this.cumulationApplied;
    }

    public StringNode getCumulationCountry() {
        return this.cumulationCountry;
    }

    public BooleanNode getShowAdditianalUnit() {
        return this.showAdditianalUnit;
    }

    public BooleanNode getDeclarantAsName() {
        return this.declarantAsName;
    }
}

