/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.forms;

import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.forms.BG;
import ch.transsoft.edec.model.sending.forms.Bill;
import ch.transsoft.edec.model.sending.forms.Cmr;
import ch.transsoft.edec.model.sending.forms.DeliveryNote;
import ch.transsoft.edec.model.sending.forms.Emergency;
import ch.transsoft.edec.model.sending.forms.Eur1;
import ch.transsoft.edec.model.sending.forms.FormBase;
import ch.transsoft.edec.model.sending.forms.ItemListForm;
import ch.transsoft.edec.model.sending.forms.Spedi;
import ch.transsoft.edec.model.sending.forms.UZ;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.util.ReflectionUtil;
import java.util.List;

public final class Forms
extends ModelNode<Forms> {
    private Eur1 eur1;
    @defaultValue(value="enabled")
    private Spedi spedi;
    private Bill bill;
    private Cmr cmr;
    private BG bg;
    private UZ uz;
    private Emergency emergency;
    private DeliveryNote deliveryNote;
    private ItemListForm itemListForm;

    public ItemListForm getItemListForm() {
        return this.itemListForm;
    }

    public Spedi getSpedi() {
        return this.spedi;
    }

    public Eur1 getEur1() {
        return this.eur1;
    }

    public Bill getBill() {
        return this.bill;
    }

    public DeliveryNote getDeliveryNote() {
        return this.deliveryNote;
    }

    public Cmr getCmr() {
        return this.cmr;
    }

    public Emergency getEmergency() {
        return this.emergency;
    }

    public BG getBg() {
        return this.bg;
    }

    public UZ getUz() {
        return this.uz;
    }

    public int getSelectedVariantIndex(IFormDesc form, List<IFormPageDesc> pages) {
        StringNode id = this.findForm(form).getVariantId();
        if (!id.isInitialized()) {
            return 0;
        }
        for (int i2 = 0; i2 < pages.size(); ++i2) {
            if (!pages.get(i2).getId().equals(id.getValue())) continue;
            return i2;
        }
        return 0;
    }

    public boolean isSelected(IFormDesc form) {
        return this.findForm(form).isEnabled();
    }

    public void setSelected(IFormDesc form, boolean value) {
        this.findForm(form).setEnabled(value);
    }

    private FormBase<?> findForm(IFormDesc form) {
        return this.findForm(form.getId());
    }

    public FormBase<?> findForm(Sending.FormName form) {
        return (FormBase)this.find(form.name());
    }

    public void setVariantId(IFormDesc form, IFormPageDesc page) {
        this.findForm(form).setVariantId(page);
    }

    public boolean hasSelectedForm() {
        Boolean[] result = new Boolean[]{false};
        ReflectionUtil.handleChildren(this, node -> {
            FormBase form = (FormBase)node;
            if (form.isEnabled()) {
                result[0] = true;
            }
        });
        return result[0];
    }
}

