/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.goodsdeclaration;

import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.domainRef;
import ch.transsoft.edec.model.infra.annotation.integralSpec;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.annotation.maxlen;
import ch.transsoft.edec.model.infra.annotation.trimmed;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.TableAdapter;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.pm.model.ISelectionFieldData;

public final class Declarant
extends ListEntry<Declarant>
implements ISelectionFieldData {
    public static ITableAdapter[] tableConfig = new ITableAdapter[]{new TableAdapter("declarantNumber", 506, IntegralNode.class), new TableAdapter("declarantName", 514, StringNode.class), new TableAdapter("companyName", 515, StringNode.class), new TableAdapter("street", 501, StringNode.class), new TableAdapter("postalCode", 508, StringNode.class), new TableAdapter("city", 509, StringNode.class), new TableAdapter("country", 504, SelectionNode.class)};
    @mandatory
    @integralSpec(digits=3)
    private IntegralNode declarantNumber;
    @maxlen(value=15)
    @trimmed
    private StringNode tin;
    @maxlen(value=35)
    @mandatory
    private StringNode declarantName;
    @maxlen(value=35)
    @mandatory
    private StringNode companyName;
    @maxlen(value=35)
    private StringNode street;
    @maxlen(value=9)
    @mandatory
    private StringNode postalCode;
    @maxlen(value=35)
    @mandatory
    private StringNode city;
    @mandatory
    @defaultValue(value="CH")
    @domainRef(value=Domain.isoCode, allowEmpty=true)
    private SelectionNode country;
    @maxlen(value=100)
    private StringNode phone;
    @maxlen(value=50)
    private StringNode email;

    public IntegralNode getDeclarantNumber() {
        return this.declarantNumber;
    }

    public StringNode getDeclarantName() {
        return this.declarantName;
    }

    public StringNode getCompanyName() {
        return this.companyName;
    }

    public StringNode getStreet() {
        return this.street;
    }

    public StringNode getPostalCode() {
        return this.postalCode;
    }

    public StringNode getCity() {
        return this.city;
    }

    public SelectionNode getCountry() {
        return this.country;
    }

    @Override
    public String getDesc() {
        StringBuilder result = new StringBuilder();
        this.append(result, this.getDeclarantName());
        this.append(result, this.getCompanyName());
        return result.toString();
    }

    private void append(StringBuilder result, IPrimitive<?> node) {
        if (!node.isInitialized()) {
            return;
        }
        if (!result.toString().isEmpty()) {
            result.append(", ");
        }
        result.append(node.getStringValue());
    }

    public StringNode getUid() {
        return this.tin;
    }

    @Override
    public String getKey() {
        return this.getDeclarantNumber().getStringValue();
    }

    public StringNode getPhone() {
        return this.phone;
    }

    public StringNode getEmail() {
        return this.email;
    }

    public StringNode getZipAndCity() {
        Object result = this.getPostalCode().getValue();
        if (!((String)result).isEmpty()) {
            result = (String)result + " ";
        }
        result = (String)result + this.getCity().getValue();
        return new StringNode((String)result);
    }

    @Override
    public String getDesc(ITextService.Language language) {
        return this.getDesc();
    }
}

