/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.itemlist;

import ch.transsoft.edec.model.infra.annotation.listType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.annotation.maxlen;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.masterdata.GenericTerm;
import ch.transsoft.edec.model.masterdata.GenericTerms;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.CompactKey;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.util.Check;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ItemList
extends ModelNode<ItemList> {
    @listType(value=GoodsItem.class)
    @mandatory
    @maxlen(value=999)
    private ListNode<GoodsItem> goodsItems;

    public ItemList() {
    }

    public void addAdjustTraderItemIdListener() {
        this.addFieldListener("goodsItems", (source, info) -> this.setTraderItemId());
    }

    private void setTraderItemId() {
        if (this.goodsItems.isEmpty()) {
            return;
        }
        IntegralNode idOfLast = this.goodsItems.get(this.goodsItems.size() - 1).getGoodsData().getTraderItemID();
        if (!idOfLast.isInitialized()) {
            this.handleGoodsItemAdded(idOfLast);
        } else {
            this.handleGoodsItemRemovedOrMoved();
        }
    }

    private void handleGoodsItemRemovedOrMoved() {
        if (this.getParent().getState().hasAl()) {
            return;
        }
        for (int i2 = 0; i2 < this.goodsItems.size(); ++i2) {
            this.goodsItems.get(i2).getGoodsData().getTraderItemID().setValue((long)i2 + 1L);
        }
    }

    private void handleGoodsItemAdded(IntegralNode idOfLast) {
        if (this.goodsItems.size() == 1) {
            idOfLast.setValue(1L);
            return;
        }
        idOfLast.setValue(this.getMaxTraderItemId() + 1L);
    }

    private long getMaxTraderItemId() {
        long result = 0L;
        for (int i2 = 0; i2 < this.goodsItems.size(); ++i2) {
            if (!this.goodsItems.get(i2).getGoodsData().getTraderItemID().isInitialized()) continue;
            result = Math.max(result, this.goodsItems.get(i2).getGoodsData().getTraderItemID().getValue());
        }
        return result;
    }

    public Sending getParent() {
        return (Sending)super.getParent();
    }

    public ItemList(List<GoodsItem> list) {
        this.goodsItems = new ListNode<GoodsItem>(list, GoodsItem.class);
    }

    public ListNode<GoodsItem> getGoodsItems() {
        return this.goodsItems;
    }

    public DecimalNode getTotalNetMass() {
        return this.getTotalNetMass(0, this.getGoodsItems().size());
    }

    public DecimalNode getTotalNetMass(int from, int to) {
        Check.assertTrue(to >= from && to <= this.size(), "invalid range[", from, ",", to, "]");
        DecimalNode result = new DecimalNode(0.0, 12, 3);
        for (int i2 = from; i2 < to; ++i2) {
            result.add(this.getGoodsItems().get(i2).getGoodsData().getNetMass());
        }
        return result;
    }

    public DecimalNode getTotalGrossMass() {
        return this.getTotalGrossMass(0, this.getGoodsItems().size());
    }

    public DecimalNode getTotalGrossMass(int from, int to) {
        Check.assertTrue(to >= from && to <= this.size(), "invalid range[", from, ",", to, "]");
        DecimalNode result = new DecimalNode(0.0, 12, 3);
        for (int i2 = from; i2 < to; ++i2) {
            result.add(this.getGoodsItems().get(i2).getGoodsData().getGrossMass());
        }
        return result;
    }

    public DecimalNode getTotalAdditionalUnit() {
        return this.getTotalAdditionalUnit(0, this.getGoodsItems().size());
    }

    public DecimalNode getTotalAdditionalUnit(int from, int to) {
        Check.assertTrue(to >= from && to <= this.size(), "invalid range[", from, ",", to, "]");
        DecimalNode result = new DecimalNode(0.0, 12, 1);
        for (int i2 = from; i2 < to; ++i2) {
            result.add(this.getGoodsItems().get(i2).getGoodsData().getAdditionalUnit());
        }
        return result;
    }

    public IntegralNode getTotalQuantity() {
        return this.getTotalQuantity(0, this.getGoodsItems().size());
    }

    public IntegralNode getTotalQuantity(int from, int to) {
        Check.assertTrue(to >= from && to <= this.size(), "invalid range[", from, ",", to, "]");
        IntegralNode result = new IntegralNode(0L);
        for (int i2 = from; i2 < to; ++i2) {
            result.add(this.getGoodsItems().get(i2).getGoodsData().getQuantity());
        }
        return result;
    }

    public DecimalNode getTotalStatisticalValueChf() {
        return this.getTotalStatisticalValueChf(0, this.getGoodsItems().size());
    }

    public DecimalNode getTotalStatisticalValueDC(String currency) {
        return this.getTotalStatisticalValueDC(0, this.getGoodsItems().size(), currency);
    }

    public String getBiggestForeignCurrency() {
        HashMap<String, DecimalNode> map = new HashMap<String, DecimalNode>();
        for (int i2 = 0; i2 < this.getGoodsItems().size(); ++i2) {
            GoodsData goodsData = this.getGoodsItems().get(i2).getGoodsData();
            DecimalNode current = (DecimalNode)map.get(goodsData.getCurrency().getValue());
            if (current == null) {
                current = new DecimalNode(0.0, 12, 2);
                map.put(goodsData.getCurrency().getValue(), current);
            }
            current.add(goodsData.getStatisticalValue());
        }
        map.remove("CHF");
        ArrayList list = new ArrayList(map.entrySet());
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, (o1, o2) -> Double.compare(((DecimalNode)o2.getValue()).getValue(), ((DecimalNode)o1.getValue()).getValue()));
        System.out.println(list);
        return (String)list.get(0).getKey();
    }

    public DecimalNode getTotalStatisticalValueChf(int from, int to) {
        Check.assertTrue(to >= from && to <= this.size(), "invalid range[", from, ",", to, "]");
        DecimalNode result = new DecimalNode(0.0, 12, 2);
        for (int i2 = from; i2 < to; ++i2) {
            result.add(this.getGoodsItems().get(i2).getGoodsData().getStatisticalValueChf());
        }
        return result;
    }

    private DecimalNode getTotalStatisticalValueDC(int from, int to, String currency) {
        Check.assertNotNull(currency);
        Check.assertTrue(to >= from && to <= this.size(), "invalid range[", from, ",", to, "]");
        DecimalNode result = new DecimalNode(0.0, 12, 2);
        for (int i2 = from; i2 < to; ++i2) {
            GoodsData goodsData = this.getGoodsItems().get(i2).getGoodsData();
            if (!currency.equals(goodsData.getCurrency().getStringValue())) continue;
            result.add(goodsData.getStatisticalValue());
        }
        return result;
    }

    public DecimalNode getTotalStatisticalValue() {
        return this.getTotalStatisticalValue(0, this.getGoodsItems().size());
    }

    public DecimalNode getTotalStatisticalValue(int from, int to) {
        Check.assertTrue(to >= from && to <= this.size(), "invalid range[", from, ",", to, "]");
        DecimalNode result = new DecimalNode(0.0, 12, 2);
        for (int i2 = from; i2 < to; ++i2) {
            result.add(this.getGoodsItems().get(i2).getGoodsData().getStatisticalValue());
        }
        return result;
    }

    public boolean isEmpty() {
        return this.getGoodsItems().isEmpty();
    }

    public int size() {
        return this.getGoodsItems().size();
    }

    public int indexOf(GoodsItem current) {
        return this.getGoodsItems().indexOf(current);
    }

    public void moveDown(GoodsItem selected) {
        this.getGoodsItems().moveDown(selected);
    }

    public void moveUp(GoodsItem selected) {
        this.getGoodsItems().moveUp(selected);
    }

    public void compact() {
        try {
            this.compactList(Services.get(IDataService.class).readSync(DataFiles.genericTerm));
        }
        catch (Exception e2) {
            Check.fail(e2, "Failed to read GenerigTerm master data");
        }
    }

    private void compactList(GenericTerms masterData) {
        HashMap<String, Descriptions> mapping = new HashMap<String, Descriptions>();
        for (GenericTerm genericTerm : masterData.getGenericTermList()) {
            mapping.put(genericTerm.getCommodityCode().getValue(), new Descriptions(genericTerm.getDescription().getStringValue(), genericTerm.getDescriptionEn().getStringValue()));
        }
        for (List list : this.createMap().values()) {
            this.compact(list, mapping);
        }
        this.setTraderItemId();
    }

    private void compact(List<GoodsItem> items, Map<String, Descriptions> mapping) {
        GoodsItem first = items.get(0);
        String commodityCode = first.getGoodsData().getCommodityCode().getValue();
        if (mapping.containsKey(commodityCode)) {
            first.getGoodsData().getDescriptionShort().setValue(mapping.get((Object)commodityCode).de);
            first.getGoodsData().getDescriptionEn().setValue(mapping.get((Object)commodityCode).en);
        }
        if (items.size() == 1) {
            return;
        }
        for (int i2 = 1; i2 < items.size(); ++i2) {
            GoodsItem current = items.get(i2);
            this.addValues(first.getGoodsData(), current.getGoodsData());
            first.addId(current.getId());
            this.getGoodsItems().remove(current);
        }
    }

    private void addValues(GoodsData first, GoodsData current) {
        first.getNetMass().cumulate(current.getNetMass());
        first.getGrossMass().cumulate(current.getGrossMass());
        first.getQuantity().cumulate(current.getQuantity());
        first.getAdditionalUnit().cumulate(current.getAdditionalUnit());
        first.getStatisticalValue().cumulate(current.getStatisticalValue());
        first.getVOCQuantity().cumulate(current.getVOCQuantity());
    }

    private Map<CompactKey, List<GoodsItem>> createMap() {
        HashMap<CompactKey, List<GoodsItem>> result = new HashMap<CompactKey, List<GoodsItem>>();
        for (GoodsItem current : this.getGoodsItems()) {
            CompactKey compactKey = current.getGoodsData().getCompactKey();
            if (compactKey == null) continue;
            ArrayList<GoodsItem> list = (ArrayList<GoodsItem>)result.get(compactKey);
            if (list == null) {
                list = new ArrayList<GoodsItem>();
                result.put(compactKey, list);
            }
            list.add(current);
        }
        return result;
    }

    public int getColisCount() {
        int result = 0;
        for (GoodsItem current : this.getGoodsItems()) {
            if (!current.getGoodsData().getQuantity().isInitialized()) continue;
            result += current.getGoodsData().getQuantity().getIntValue();
        }
        return result;
    }

    public void setCurrencyRate(String currency, Number currencyRate) {
        for (GoodsItem current : this.getGoodsItems()) {
            DecimalNode currentRate;
            if (!current.getGoodsData().getCurrency().getValue().equals(currency) || (currentRate = current.getGoodsData().getCurrencyRate()).isInitialized() && currentRate.getValue().doubleValue() == currencyRate.doubleValue()) continue;
            current.getGoodsData().getCurrencyRate().setValue(currencyRate);
        }
    }

    public StringNode getTotalCurrency() {
        StringNode result = new StringNode(3);
        for (GoodsItem current : this.getGoodsItems()) {
            StringNode currency = current.getGoodsData().getCurrency();
            if (!currency.isInitialized()) continue;
            if (result.isInitialized()) {
                if (result.isEquals(currency)) continue;
                result.setValue("MIX");
                continue;
            }
            result.setValue(currency.getStringValue());
        }
        return result;
    }

    private class Descriptions {
        String de;
        String en;

        public Descriptions(String de, String en) {
            this.de = de;
            this.en = en;
        }
    }
}

