/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.action;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.model.ISelectionFieldData;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.awt.Color;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class ActionBase
extends AbstractAction
implements ISelectionFieldData,
IDisposable {
    private final Disposables disposables = new Disposables();

    public ActionBase(String name) {
        super(name);
    }

    public ActionBase(String name, String smallIcon, String largeIcon) {
        this(name, IconLoader.getIcon(smallIcon), IconLoader.getIcon(largeIcon));
    }

    public ActionBase(String name, String smallIcon) {
        super(name, IconLoader.getIcon(smallIcon));
    }

    public ActionBase(String name, Color color) {
        super(name, IconLoader.getMonochromaticIcon(color, 16, 16));
    }

    public ActionBase(String name, Icon smallIcon, Icon largeIcon) {
        super(name, smallIcon);
        this.setLargeIcon(largeIcon);
    }

    public void setLargeIcon(Icon largeIcon) {
        this.putValue("SwingLargeIconKey", largeIcon);
    }

    public void setSmallIcon(Icon largeIcon) {
        this.putValue("SmallIcon", largeIcon);
    }

    public void setTooltip(String text) {
        this.putValue("ShortDescription", text);
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    protected void setAccelerator(int keyCode) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, 128);
        this.putValue("AcceleratorKey", keyStroke);
    }

    protected static Icon getIcon(String string) {
        return IconLoader.getIcon(string);
    }

    protected static String getText(int id) {
        return Services.get(ITextService.class).getText(id);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    @Override
    public String getDesc() {
        return this.getName();
    }

    @Override
    public String getDesc(ITextService.Language language) {
        return this.getDesc();
    }

    @Override
    public String getKey() {
        return "";
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public void add(IDisposable disposable) {
        this.disposables.add(disposable);
    }
}

