/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.action;

import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.action.IActionService;
import ch.transsoft.edec.util.Check;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JToolBar;

public abstract class ActionServiceBase
implements IActionService {
    protected Map<Class<?>, ActionBase> actions = new HashMap();
    protected JToolBar toolBar;

    @Override
    public void languageChanged() {
        for (ActionBase action : this.actions.values()) {
            action.dispose();
        }
        this.actions.clear();
        this.createToolbar();
        this.initActionsWithListener();
    }

    @Override
    public Component createToolbar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setPreferredSize(new Dimension(0, 70));
        return this.toolBar;
    }

    @Override
    public <T extends ActionBase> T getAction(Class<T> action) {
        ActionBase result = this.actions.get(action);
        if (result == null) {
            result = (ActionBase)this.createInstance(action);
            this.actions.put(action, result);
        }
        return (T)result;
    }

    protected <T> T createInstance(Class<T> action) {
        try {
            return action.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }
}

