/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend;

import ch.e_dec.xml.schema.edecreceiptresponse.v3.ReceiptRequestResponse;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.TaxationDecisionExportType;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauFetchInfo;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.XMLReader;
import ch.transsoft.edec.model.infra.XMLWriter;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.masterdata.DataNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.IBackendJob;
import ch.transsoft.edec.service.backend.jobs.JobUtil;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.aza.AzaResponse;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.service.ezv.evv.sigcheck.DocumentValidator;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.masterdata.IDataFile;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;

public abstract class BackendJobBase
implements IBackendJob {
    private final File lockFile;
    private final File versionFile;
    private final String currentVersion;

    public BackendJobBase(IConfigService.Module module) {
        this.lockFile = Services.get(IConfigService.class).getLockFilePath(module);
        this.versionFile = Services.get(IConfigService.class).getVersionFilePath();
        this.currentVersion = Services.get(IConfigService.class).getVersionString();
    }

    @Override
    public File getLockFile() {
        return this.lockFile;
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public File getVersionFile() {
        return this.versionFile;
    }

    protected Sending readSending(IndexEntry indexEntry) throws Exception {
        return this.readSending(indexEntry.getSendingId());
    }

    protected Sending readSending(String sendingId) throws Exception {
        File file = SendingUtil.getSendingPath(sendingId, true);
        return SendingUtil.readSending(sendingId, file);
    }

    protected ImportSending readImportSending(ReceiptEntry indexEntry) throws Exception {
        EdecDateNode date = indexEntry.getDate();
        ImportSendingList list = this.readImportSendingList(date);
        ImportSending importSending = list.getImportSending(indexEntry.getKey());
        Check.assertNotNull(importSending, "ImportSending " + indexEntry.getCustomsReferenceNumberStr() + " not found in file " + SendingUtil.getImportSendingListPath(date, false));
        return importSending;
    }

    protected ImportSendingList readImportSendingList(EdecDateNode date) throws Exception {
        File file = SendingUtil.getImportSendingListPathWithoutExtension(date, false);
        return FileUtil.readFile(file, ImportSendingList.class);
    }

    protected void saveImportSendingList(ImportSendingList importSendingList) {
        File file = SendingUtil.getImportSendingListPath(importSendingList.getDate(), true);
        try {
            FileUtil.writeGZipFile(importSendingList, file);
        }
        catch (Exception ex) {
            Check.fail(ex);
        }
    }

    protected BordereauInfo readBordereauInfo(BordereauEntry entry) throws Exception {
        File file = SendingUtil.getBordereauInfoPathWithoutExtension(entry, true);
        return FileUtil.readFile(file, BordereauInfo.class);
    }

    protected void saveBordereauInfo(BordereauInfo info) throws Exception {
        File file = SendingUtil.getBordereauInfoPath(info.createBordereauEntry(), false);
        FileUtil.writeGZipFile(info, file);
    }

    protected void saveBordereauFetchInfo(BordereauFetchInfo info) {
        File file = this.getBordereauFetchInfoPath();
        try {
            XMLWriter xmlWriter = new XMLWriter();
            xmlWriter.write(file, info, false);
        }
        catch (Exception ex) {
            Check.fail(ex);
        }
    }

    protected BordereauFetchInfo readBordereauFetchInfo() {
        try {
            File file = this.getBordereauFetchInfoPath();
            XMLReader reader = new XMLReader();
            return reader.read(new FileInputStream(file), BordereauFetchInfo.class);
        }
        catch (Exception e2) {
            return NodeFactory.create(BordereauFetchInfo.class);
        }
    }

    private File getBordereauFetchInfoPath() {
        String filename = BordereauFetchInfo.class.getSimpleName() + ".xml";
        File bordereauDir = Services.get(IConfigService.class).getBordereauDir();
        bordereauDir.mkdirs();
        return new File(bordereauDir, filename);
    }

    protected void saveSending(Sending sending) {
        Check.assertTrue(sending.hasSendingId(), "SendingId not set!");
        File file = SendingUtil.getSendingPath(sending.getSendingId(), false);
        sending.getExpoVitVersion().setValue(this.currentVersion);
        try {
            XMLWriter xmlWriter = new XMLWriter();
            xmlWriter.write(file, sending, false);
        }
        catch (Exception ex) {
            Check.fail(ex);
        }
    }

    protected void log(Throwable t, String ... message) {
        Services.get(ILoggingService.class).logAndReport(t, message);
    }

    protected boolean saveEvvToDisk(String sendingId, EvvResponse evv) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(evv.getSoapMessage());
        File file = SendingUtil.getEvvPath(sendingId, false);
        FileUtil.copy((InputStream)in, file);
        return DocumentValidator.validateFromFile(file, sendingId);
    }

    protected boolean isCurrentSending(String sendingIdStr) {
        if (!this.getCurrentSending().hasSendingId()) {
            return false;
        }
        return this.getCurrentSending().getSendingId().equals(sendingIdStr);
    }

    protected Sending getCurrentSending() {
        return Services.get(IAppService.class).getCurrentSending();
    }

    protected void writeMasterData(DataNode<?> data) throws Exception {
        XMLWriter writer = new XMLWriter();
        File path = JobUtil.getMasterDataPath(data.getDataFileType(), false);
        writer.write(path, data, true);
    }

    protected void saveAl(Sending backgroundSending, AzaResponse response) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(response.getAl());
        File file = SendingUtil.getAlPath(backgroundSending.getSendingId(), false);
        FileUtil.copy((InputStream)in, file);
    }

    protected <T extends DataNode<T>> T readMasterData(IDataFile<T> dataFile) throws Exception {
        File file = JobUtil.getMasterDataPath(dataFile, true);
        if (!file.exists()) {
            return null;
        }
        XMLReader reader = new XMLReader();
        return (T)((DataNode)reader.read(new FileInputStream(file), dataFile.contentType()));
    }

    protected Date getAcceptanceDate(ReceiptRequestResponse evv) {
        TaxationDecisionExportType receipt = evv.getTaxationDecisionExport();
        return DateUtil.getTimestamp(receipt.getAcceptanceDate(), receipt.getAcceptanceTime());
    }

    @Override
    public boolean showWaitCursor() {
        return false;
    }

    @Override
    public boolean skipAfterShutdown() {
        return false;
    }

    @Override
    public boolean isInterruptible() {
        return false;
    }
}

