/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IActionLockListener;
import ch.transsoft.edec.service.backend.IBackendJob;
import ch.transsoft.edec.service.backend.IBackendWorkerListener;
import ch.transsoft.edec.service.backend.LockFile;
import ch.transsoft.edec.service.backend.ShutdownMessage;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.gui.bar.StateDisplayFacade;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.ThreadUtil;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class BackendWorker
implements Runnable {
    private static final int CHALLENGE_INTERVAL = 3000;
    private final LinkedBlockingDeque<IBackendJob> queue = new LinkedBlockingDeque();
    private Thread workerThread;
    private Thread lockKeeperThread;
    private final String user;
    private final String guid;
    private final AtomicInteger cursorCount = new AtomicInteger(0);
    private volatile int jobCount = 0;
    private final AtomicInteger actionLockCount = new AtomicInteger(0);
    private final ListenerList<IActionLockListener> listeners = new ListenerList();
    private final ListenerList<IBackendWorkerListener> backendWorkerListeners = new ListenerList();
    private String lastJobMessage;
    private boolean lockFileErrorOccurred = false;
    private final String version;
    private volatile boolean shutdown;
    private IBackendJob currentJob;

    public BackendWorker() {
        this.user = Services.get(IConfigService.class).getUserName();
        this.version = Services.get(IConfigService.class).getVersionString();
        this.guid = UUID.randomUUID().toString();
        this.createAndStartWorkerThread();
    }

    private void createAndStartWorkerThread() {
        this.workerThread = new Thread((Runnable)this, "backend");
        this.workerThread.start();
    }

    public void jam(IBackendJob job) {
        this.incrementJobCount();
        if (this.doLock(job)) {
            this.lockActions(job);
        }
        if (job.showWaitCursor()) {
            this.showCursor();
        }
        this.queue.addFirst(job);
    }

    public void put(IBackendJob job, boolean force) {
        if (!force && this.isActionsLocked() && this.doLock(job)) {
            this.getStateDisplay().stateWork("<font color=red>" + Services.getText(900) + "<br>" + this.lastJobMessage + "</font>");
            return;
        }
        this.incrementJobCount();
        if (this.doLock(job)) {
            this.lockActions(job);
        }
        if (job.showWaitCursor()) {
            this.showCursor();
        }
        this.queue.addLast(job);
    }

    private boolean doLock(IBackendJob job) {
        return job.locksActions();
    }

    private StateDisplayFacade getStateDisplay() {
        return Services.get(IGuiService.class).getStatusDisplayFacade();
    }

    public synchronized boolean isActionsLocked() {
        return this.actionLockCount.get() > 0;
    }

    private synchronized void incrementJobCount() {
        this.checkJobCount();
        ++this.jobCount;
        if (this.jobCount == 1) {
            this.notifyBackendWorkerListener(true);
        }
    }

    private void lockActions(IBackendJob job) {
        this.actionLockCount.incrementAndGet();
        this.lastJobMessage = job.getMessage();
        if (this.actionLockCount.get() == 1) {
            this.triggerActionLockListeners(true, job.getMessage());
        }
    }

    private void unlockActions() {
        this.actionLockCount.decrementAndGet();
        if (this.actionLockCount.get() == 0) {
            this.triggerActionLockListeners(false, null);
        }
    }

    private void triggerActionLockListeners(boolean lock, String jobName) {
        SwingUtilities.invokeLater(() -> this.notifyInEdt(lock, jobName));
    }

    private void notifyInEdt(boolean lock, String jobName) {
        for (IActionLockListener listener : this.listeners) {
            if (lock) {
                listener.lock(jobName);
                continue;
            }
            listener.unlock();
        }
    }

    private void notifyBackendWorkerListener(boolean busy) {
        for (IBackendWorkerListener listener : this.backendWorkerListeners) {
            if (busy) {
                listener.busy();
                continue;
            }
            listener.idle();
        }
    }

    private void checkJobCount() {
        Check.assertTrue(this.jobCount >= 0, "Unexpected Job Count " + this.jobCount);
    }

    @Override
    public void run() {
        IBackendJob job = null;
        while (!Thread.interrupted()) {
            try {
                this.currentJob = job = this.queue.takeFirst();
                if (job instanceof ShutdownMessage) {
                    if (this.queue.isEmpty()) {
                        return;
                    }
                    this.queue.add(job);
                    continue;
                }
                this.executeJobs(job);
            }
            catch (Exception e2) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.handleError(job, e2);
            }
        }
    }

    public void interruptCurrentJob() {
        if (this.currentJob == null) {
            return;
        }
        this.workerThread.interrupt();
        this.jobHasFinished(this.currentJob);
        this.currentJob = null;
        this.createAndStartWorkerThread();
    }

    private void showCursor() {
        if (this.cursorCount.get() == 0) {
            this.showCursor(true);
        }
        this.cursorCount.incrementAndGet();
    }

    private void hideCursor() {
        this.cursorCount.decrementAndGet();
        if (this.cursorCount.get() == 0) {
            this.showCursor(false);
        }
    }

    private void showCursor(boolean waitCursor) {
        SwingUtilities.invokeLater(() -> Services.get(IGuiService.class).setHourGlassCursor(waitCursor));
    }

    private void handleError(IBackendJob job, Throwable e2) {
        Check.assertNotNull(job);
        SwingUtilities.invokeLater(() -> job.handleError(e2));
    }

    private void executeJobs(IBackendJob job) throws Exception {
        if (this.shutdown && job.skipAfterShutdown()) {
            return;
        }
        try {
            this.showDialog(job.getMessage(), job.isInterruptible());
            if (job.needsLocking()) {
                this.acquireLock(job.getLockFile(), job.getVersionFile());
            }
            this.executeJob(job);
        }
        finally {
            if (!Thread.currentThread().isInterrupted()) {
                this.jobHasFinished(job);
            }
        }
    }

    private synchronized void jobHasFinished(IBackendJob job) {
        if (this.currentJob == null) {
            return;
        }
        this.decrementJobCount();
        if (this.doLock(job)) {
            this.unlockActions();
        }
        if (job.needsLocking()) {
            this.releaseLock(job.getLockFile());
        }
        if (job.showWaitCursor()) {
            this.hideCursor();
        }
        this.hideDialog();
        this.currentJob = null;
    }

    private synchronized void decrementJobCount() {
        --this.jobCount;
        this.checkJobCount();
        if (this.jobCount == 0) {
            this.notifyBackendWorkerListener(false);
        }
    }

    public synchronized boolean isProcessing() {
        return this.jobCount > 0;
    }

    private void executeJob(IBackendJob job) throws Exception {
        job.execute();
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.signalJobDone(job);
    }

    private void signalJobDone(IBackendJob job) {
        ThreadUtil.invokeAndWait(job::done);
    }

    private void hideDialog() {
        if (this.isProcessing()) {
            return;
        }
        Timer timer = new Timer(600, e2 -> {
            if (this.isProcessing()) {
                return;
            }
            this.getStateDisplay().hide();
        });
        timer.setRepeats(false);
        timer.start();
    }

    private void showDialog(String message, boolean isInterruptible) {
        this.getStateDisplay().setVisible(message, isInterruptible);
    }

    private void stopKeeping() {
        if (this.lockKeeperThread == null) {
            return;
        }
        this.lockKeeperThread.interrupt();
        this.lockKeeperThread = null;
    }

    private void startKeeping(File lockFile) {
        this.lockKeeperThread = new Thread(() -> {
            while (true) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e2) {
                    return;
                }
                this.writeLockFile(lockFile);
            }
        });
        this.lockKeeperThread.setPriority(10);
        this.lockKeeperThread.start();
    }

    private void releaseLock(File lockFile) {
        this.stopKeeping();
        lockFile.delete();
    }

    private void acquireLock(File lockFile, File versionFile) {
        if (!lockFile.exists()) {
            this.writeLockFile(lockFile);
            this.startKeeping(lockFile);
            this.writeVersionFile(versionFile);
            return;
        }
        this.challenge(lockFile);
        this.writeLockFile(lockFile);
        this.startKeeping(lockFile);
    }

    private void writeVersionFile(File versionFile) {
        try (FileWriter writer = FileUtil.createFileWriter(versionFile);){
            writer.write(this.version);
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logSilent(e2, "Silent: Failed to write version file");
        }
    }

    private void challenge(File lockFile) {
        HashSet<String> challengers = new HashSet<String>();
        LockFile lock = LockFile.read(lockFile);
        if (lock == null) {
            return;
        }
        this.getStateDisplay().stateWait(lock.getUser());
        while (true) {
            this.writeLockFile(lockFile);
            int random = (int)(Math.random() * 3000.0 * (double)challengers.size()) + 3000;
            ThreadUtil.sleep(random);
            lock = LockFile.read(lockFile);
            if (lock == null) {
                return;
            }
            if (lock.getGuid().equals(this.guid)) {
                return;
            }
            challengers.add(lock.getGuid());
        }
    }

    private synchronized void writeLockFile(File lockFile) {
        try {
            new LockFile(this.user, this.guid).write(lockFile);
        }
        catch (FileNotFoundException e2) {
            if (this.lockFileErrorOccurred) {
                return;
            }
            this.lockFileErrorOccurred = true;
            throw Check.fail(e2, Services.getText(629), lockFile.getParent());
        }
        catch (IOException e3) {
            throw Check.fail(e3);
        }
    }

    public IDisposable add(IActionLockListener listener) {
        Check.checkEDT();
        return this.listeners.add(listener);
    }

    public IDisposable add(IBackendWorkerListener listener) {
        Check.checkEDT();
        return this.backendWorkerListeners.add(listener);
    }

    public void shutdown() {
        this.shutdown = true;
        this.put(new ShutdownMessage(), true);
    }
}

