/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.TransactionFile;
import ch.transsoft.edec.service.backend.TransactionReport;
import ch.transsoft.edec.service.backend.TransactionReporter;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerManagementFacade;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public final class SafeTransactionReporter
implements TransactionReporter {
    private static final SafeTransactionReporter instance = new SafeTransactionReporter(Services.get(IConfigService.class)::getTransactionExportBacklogFile, new TransactionReporter(){

        @Override
        public void reportTransactionExport(String guid, String customsDeclarationNumber, int module, boolean productive) throws Exception {
            CustomerManagementFacade.reportTransactionExport(guid, customsDeclarationNumber, module, productive);
        }

        @Override
        public void reportTransactionImport(String guid, String customsDeclarationNumber, boolean productive) throws Exception {
            CustomerManagementFacade.reportTransactionImport(guid, customsDeclarationNumber, productive);
        }
    });
    private final TransactionReporter reporter;
    private final Supplier<Path> failedTransactionFilePath;

    public static void saveReportTransactionExport(String guid, String customsDeclarationNumber, int module, boolean productive) {
        instance.reportTransactionExport(guid, customsDeclarationNumber, module, productive);
    }

    public static void saveReportTransactionImport(String guid, String customsDeclarationNumber, boolean productive) {
        instance.reportTransactionImport(guid, customsDeclarationNumber, productive);
    }

    public static boolean isBacklogCritical() {
        return SafeTransactionReporter.isCritical(instance.loadBacklog());
    }

    private static boolean isCritical(List<TransactionReport> backlog) {
        return !backlog.isEmpty() && DateUtil.getAge(backlog.get(0).getTimeStamp()) >= 30 && backlog.size() > 10;
    }

    public SafeTransactionReporter(Supplier<Path> failedTransactionFilePath, TransactionReporter reporter) {
        this.reporter = reporter;
        this.failedTransactionFilePath = failedTransactionFilePath;
    }

    @Override
    public void reportTransactionExport(String guid, String customsDeclarationNumber, int module, boolean productive) {
        this.reportTransaction(guid, customsDeclarationNumber, module, productive);
    }

    @Override
    public void reportTransactionImport(String guid, String customsDeclarationNumber, boolean productive) {
        this.reportTransaction(guid, customsDeclarationNumber, 3, productive);
    }

    private void reportTransaction(String guid, String customsDeclarationNumber, int module, boolean productive) {
        boolean sent;
        LinkedList<TransactionReport> failedTransactions = this.loadBacklog();
        failedTransactions.addLast(new TransactionReport(guid, customsDeclarationNumber, module, productive, new Date()));
        while (!failedTransactions.isEmpty() && (sent = this.sendToBackend(failedTransactions.peekLast()))) {
            failedTransactions.removeLast();
        }
        this.writeTransactionBacklog(failedTransactions);
    }

    private void writeTransactionBacklog(Collection<TransactionReport> failedTransactions) {
        Path logPath = this.failedTransactionFilePath.get();
        FileUtil.recursiveDelete(logPath.toFile());
        try (BufferedWriter writer = Files.newBufferedWriter(logPath, new OpenOption[0]);){
            TransactionFile.write(failedTransactions, writer);
        }
        catch (IOException e2) {
            Services.get(ILoggingService.class).logSilent(e2, "transaction backlog could not be saved to a file");
        }
    }

    private boolean sendToBackend(TransactionReport report) {
        try {
            if (report.isImport()) {
                this.reporter.reportTransactionImport(report.getGuid(), report.getCustomsDeclarationNumber(), report.isProductive());
            } else {
                this.reporter.reportTransactionExport(report.getGuid(), report.getCustomsDeclarationNumber(), report.getModule(), report.isProductive());
            }
            return true;
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logSilent(e2, "Could not send transaction to CRM");
            return false;
        }
    }

    public LinkedList<TransactionReport> loadBacklog() {
        LinkedList<TransactionReport> linkedList;
        Path logPath = this.failedTransactionFilePath.get();
        if (!Files.exists(logPath, new LinkOption[0])) {
            return new LinkedList<TransactionReport>();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(logPath, new OpenOption[0]), StandardCharsets.UTF_8));
        try {
            linkedList = TransactionFile.parse(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                Services.get(ILoggingService.class).logSilent(e2, "transaction backlog could not be loaded from file");
                return new LinkedList<TransactionReport>();
            }
        }
        reader.close();
        return linkedList;
    }
}

