/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend;

import ch.transsoft.edec.service.backend.TransactionReport;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.NumberUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;

public final class TransactionFile {
    public static final String SEPARATOR = ";";

    private TransactionFile() {
    }

    public static void write(Collection<TransactionReport> failedTransactions, BufferedWriter writer) throws IOException {
        failedTransactions.stream().map(it -> it.getGuid() + SEPARATOR + it.getCustomsDeclarationNumber() + SEPARATOR + it.getModule() + SEPARATOR + it.isProductive() + SEPARATOR + DateUtil.formatDate(it.getTimeStamp())).forEach(it -> {
            try {
                writer.write((String)it);
                writer.write("\n");
            }
            catch (IOException e2) {
                throw Check.fail(e2);
            }
        });
        writer.flush();
    }

    public static LinkedList<TransactionReport> parse(BufferedReader reader) throws IOException {
        return reader.lines().map(TransactionFile::parseFromString).collect(Collectors.toCollection(LinkedList::new));
    }

    private static TransactionReport parseFromString(String line) {
        String[] parts = line.split(SEPARATOR);
        return new TransactionReport(parts[0], parts[1], NumberUtil.parseInteger(parts[2]), Boolean.parseBoolean(parts[3]), DateUtil.parseDate(parts[4]));
    }
}

