/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.manip.ArchiveUpdate;
import ch.transsoft.edec.service.backend.jobs.manip.IIndexUpdater;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.IndexUpdate;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Check;

public class MoveSendingToArchiveJob
extends BackendJobBase {
    private volatile Sending backgroundSending;
    private volatile String sendingId;
    private volatile IIndexUpdater indexUpdater;
    private volatile IIndexUpdater archiveUpdater;
    private volatile ISendingManip manip;

    public MoveSendingToArchiveJob(String sendingId) {
        super(IConfigService.Module.moduleExport);
        Check.assertNotNull(sendingId);
        this.sendingId = sendingId;
        if (this.isCurrentSending(sendingId)) {
            this.backgroundSending = this.getCurrentSending().getCopy((ModelNode)null);
        }
    }

    @Override
    public void done() {
        if (this.manip == null) {
            return;
        }
        this.indexUpdater.notifyChange();
        this.archiveUpdater.notifyChange();
        if (!this.isCurrentSending(this.sendingId)) {
            return;
        }
        this.manip.execute(this.getCurrentSending());
        this.getCurrentSending().clearPendingChanges();
    }

    @Override
    public String getMessage() {
        return Services.getText(860);
    }

    @Override
    public void execute() throws Exception {
        if (this.backgroundSending == null) {
            this.backgroundSending = this.readSending(this.sendingId);
        }
        this.manip = this.doExecute(this.backgroundSending);
        this.manip.execute(this.backgroundSending);
        this.saveSending(this.backgroundSending);
        IndexEntry indexEntry = this.backgroundSending.getIndexEntry();
        this.indexUpdater = new IndexUpdate(indexEntry);
        this.indexUpdater.deleteEntry();
        this.archiveUpdater = new ArchiveUpdate(indexEntry);
        this.archiveUpdater.saveOrUpdateIndex();
    }

    private ISendingManip doExecute(Sending backgroundSending2) {
        return new ISendingManip(){

            @Override
            public void execute(Sending sending) {
                sending.getArchive().setValue(true);
            }
        };
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(861));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

