/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;

public class OpenSendingJob
extends BackendJobBase {
    private volatile Sending sending;
    private final IndexEntry indexEntry;

    public OpenSendingJob(IndexEntry indexEntry) {
        super(IConfigService.Module.moduleExport);
        this.indexEntry = indexEntry;
    }

    @Override
    public void done() {
        this.sending.clearPendingChanges();
        Services.get(IAppService.class).openSending(this.sending);
        Services.get(IGuiService.class).selectExportTab(GuiService.ExportTab.header);
    }

    @Override
    public void execute() throws Exception {
        this.sending = this.readSending(this.indexEntry);
    }

    @Override
    public String getMessage() {
        return Services.getText(862) + " " + this.indexEntry.getTraderDeclarationNumber().getStringValue();
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(604));
    }

    @Override
    public boolean showWaitCursor() {
        return true;
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

