/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.XMLReader;
import ch.transsoft.edec.model.sending.EvvValidationState;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.ISendingHandler;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.evv.sigcheck.DocumentValidator;
import ch.transsoft.edec.service.index.sending.IIndexService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class RecreateIndexJob
extends BackendJobBase {
    private volatile List<String> errors = new ArrayList<String>();
    private volatile Index index;
    private volatile Map<Integer, Index> archive = new HashMap<Integer, Index>();

    public RecreateIndexJob() {
        super(IConfigService.Module.moduleExport);
    }

    @Override
    public void done() {
        Services.get(IIndexService.class).clearIndices();
        Services.get(IIndexService.class).indexChanged(this.index);
        for (Integer year : this.archive.keySet()) {
            Services.get(IIndexService.class).archiveChanged(year, this.archive.get(year));
        }
        if (this.errors.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        int errorCounter = 0;
        for (String error : this.errors) {
            if (++errorCounter > 10) break;
            message.append(error);
            message.append("\n");
        }
        Services.get(ILoggingService.class).logAndReport(Services.getText(877), message.toString());
    }

    @Override
    public void execute() throws Exception {
        List<File> result = FileUtil.recursiveDelete(IndexUtil.getIndexDir(false));
        if (!result.isEmpty()) {
            Check.fail(Services.getText(868) + " " + result);
        }
        if (!(result = FileUtil.recursiveDelete(IndexUtil.getArchiveDir(false))).isEmpty()) {
            Check.fail(Services.getText(869) + " " + result);
        }
        this.index = NodeFactory.create(Index.class);
        this.readSendings();
        IndexUtil.writeIndex(this.index);
        for (Integer year : this.archive.keySet()) {
            IndexUtil.writeArchive(year, this.archive.get(year));
        }
    }

    private void readSendings() {
        SendingUtil.forAllSendings(new ISendingHandler(){

            @Override
            public void handle(File dir, File path, String yearPart, String sendingPart) {
                RecreateIndexJob.this.handleSending(path, yearPart, sendingPart);
            }
        });
    }

    private void handleSending(File path, String yearPart, String sendingPart) {
        if (!path.exists()) {
            return;
        }
        try {
            XMLReader reader = new XMLReader();
            Sending sending = reader.read(new FileInputStream(path), Sending.class);
            sending.setSendingId(yearPart + "-" + sendingPart);
            if (sending.getState().hasEvv()) {
                this.handleEvv(sending);
            }
            if (sending.getArchive().getValue().booleanValue()) {
                this.getArchivePart(sending).getEntryList().add(sending.getIndexEntry());
            } else {
                this.index.getEntryList().add(sending.getIndexEntry());
            }
        }
        catch (Exception e2) {
            this.errors.add(e2.getMessage() + " in " + path);
        }
    }

    private void handleEvv(Sending sending) throws Exception {
        boolean saveSending = false;
        File evvVile = SendingUtil.getEvvPath(sending.getSendingId(), false);
        if (sending.getState().getEvvValidationState() == EvvValidationState.undefined) {
            boolean evvValid = DocumentValidator.validateFromFile(evvVile, sending.getSendingId());
            sending.getState().setEvvValid(evvValid);
            saveSending = true;
        }
        if (!sending.getAcceptanceDate().isInitialized()) {
            Document doc = DocumentUtil.readXmlDoc(evvVile);
            DocumentUtil.setAcceptanceDate(sending.getAcceptanceDate(), doc);
            saveSending = true;
        }
        if (saveSending) {
            this.saveSending(sending);
        }
    }

    private Index getArchivePart(Sending sending) {
        int year = SendingUtil.getYear(sending.getSendingId());
        Index part = this.archive.get(year);
        if (part == null) {
            part = NodeFactory.create(Index.class);
            this.archive.put(year, part);
        }
        return part;
    }

    @Override
    public String getMessage() {
        return Services.getText(871);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(872));
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

