/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.manip.IIndexUpdater;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.IndexUpdate;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.SendingUtil;

public class SaveSendingInitiallyJob
extends BackendJobBase {
    private volatile Sending backgroundSending;
    private volatile IIndexUpdater indexUpdater;
    private volatile ISendingManip manip;
    private String historyEntry;
    private Sending currentSending;

    public SaveSendingInitiallyJob(Sending currentSending, String historyEntry) {
        super(IConfigService.Module.moduleExport);
        this.historyEntry = historyEntry;
        this.checkSendingNotInitialized(currentSending);
        this.backgroundSending = currentSending.getCopy((ModelNode)null);
        this.currentSending = currentSending;
    }

    private void checkSendingNotInitialized(Sending currentSending) {
        if (currentSending.hasSendingId()) {
            Check.fail(new Object[]{"Sending was already initialized ", currentSending.getSendingId(), ". State ", Services.get(IAppService.class).getAppState()});
        }
    }

    @Override
    public void done() {
        this.indexUpdater.notifyChange();
        this.manip.execute(this.currentSending);
        this.currentSending.clearPendingChanges();
    }

    @Override
    public final void execute() throws Exception {
        this.manip = this.doExecute(this.backgroundSending);
        this.manip.execute(this.backgroundSending);
        this.saveSending(this.backgroundSending);
        IndexEntry indexEntry = this.backgroundSending.getIndexEntry();
        this.indexUpdater = new IndexUpdate(indexEntry);
        this.indexUpdater.saveOrUpdateIndex();
    }

    protected ISendingManip doExecute(Sending backgroundSending) throws Exception {
        final String sendingId = SendingUtil.createSendingId(backgroundSending);
        ISendingManip manip = new ISendingManip(){

            @Override
            public void execute(Sending sending) {
                SaveSendingInitiallyJob.this.checkSendingNotInitialized(SaveSendingInitiallyJob.this.currentSending);
                sending.addHistoryEntry(SaveSendingInitiallyJob.this.historyEntry);
                sending.setSendingId(sendingId);
                if (sending.getGoodsDeclaration().getTraderDeclarationNumber().isInitialized()) {
                    return;
                }
                sending.getGoodsDeclaration().getTraderDeclarationNumber().setValue(sendingId);
            }
        };
        manip.execute(backgroundSending);
        return manip;
    }

    @Override
    public String getMessage() {
        return Services.getText(879);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(880));
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

