/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.e_dec.services.edecservice.v4.GoodsDeclarationsFault;
import ch.transsoft.edec.model.sending.ALState;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.SafeTransactionReporter;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.SendingManipJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.aza.AzaErrorHandler;
import ch.transsoft.edec.service.ezv.aza.AzaResponse;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import jakarta.xml.ws.WebServiceException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Date;

public class SendAzaJob
extends SendingManipJobBase {
    private final String guid;
    private final OperatingMode mode;
    private final String uid;
    private volatile boolean reportTransaction = false;
    private volatile String customsDeclarationNumber;

    public SendAzaJob(Sending sending) {
        this(sending, Services.get(IConfigService.class).getGuid(), Services.get(IConfigService.class).getOperatingModeForActiveModule(), Services.get(IConfigService.class).getEdecExportIdentification());
    }

    public SendAzaJob(Sending sending, String guid, OperatingMode operatingMode, String uid) {
        super(sending);
        this.guid = guid;
        this.mode = operatingMode;
        this.uid = uid;
    }

    @Override
    protected void postProcessing() {
        if (this.reportTransaction) {
            SafeTransactionReporter.saveReportTransactionExport(this.guid, this.customsDeclarationNumber, 1, this.mode == OperatingMode.production);
        }
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    protected ISendingManip doExecute(Sending backgroundSending) throws Exception {
        AzaResponse response = Services.get(IEZVService.class).sendAza(backgroundSending);
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (response.hasAl()) {
            this.saveAl(backgroundSending, response);
            if (backgroundSending.getGoodsDeclaration().getCorrectionCode().getValue().getKeyAsInt() == 1) {
                this.reportTransaction = true;
                this.customsDeclarationNumber = response.getAcceptance().getCustomsDeclarationNumber();
            }
        }
        return sending -> this.manipulatorFunction(response, sending, this.mode);
    }

    private void manipulatorFunction(AzaResponse response, Sending sending, OperatingMode mode) {
        sending.getGoodsDeclaration().getDeclarant().getUid().setValue(this.uid);
        sending.addHistoryEntry("Sent to EZV");
        if (response.hasStatus()) {
            sending.setStatus(response.getStatus().getStatus().intValue());
            this.setTransmissionTimestamp(response, sending);
        }
        if (response.hasAl()) {
            sending.getState().setAlState(ALState.complete);
            sending.getGoodsDeclaration().getCustomsDeclarationNumber().setValue(response.getAcceptance().getCustomsDeclarationNumber());
            sending.setCustomsDeclarationVersion(response.getAcceptance().getCustomsDeclarationVersion().longValue());
            sending.getState().setOperatingMode(mode);
        }
    }

    private void setTransmissionTimestamp(AzaResponse response, Sending sending) {
        Date timestamp = DateUtil.getTimestamp(response.getStatus().getStatusDate(), response.getStatus().getStatusTime());
        sending.getTransmissionDate().setValue(timestamp, true);
    }

    @Override
    public String getMessage() {
        return Services.getText(883);
    }

    @Override
    public void handleErrorForCurrentSending(Sending sending, Throwable e2) {
        if (e2 instanceof WebServiceException) {
            if (e2.getCause() instanceof UnknownHostException) {
                Services.get(ILoggingService.class).logAndReport(e2, this.getStandardErrorMessage());
                return;
            }
            if (e2.getCause() instanceof ConnectException) {
                Services.get(ILoggingService.class).logAndReport(e2, this.getStandardErrorMessage());
                return;
            }
            Services.get(ILoggingService.class).logAndReport(e2, this.getStandardErrorMessage());
            return;
        }
        if (!sending.getState().hasAl()) {
            sending.getState().setAlState(ALState.error);
        }
        if (e2 instanceof GoodsDeclarationsFault) {
            new AzaErrorHandler(sending, (GoodsDeclarationsFault)e2);
            return;
        }
        Check.fail(e2, Services.getText(884));
    }

    private String getStandardErrorMessage() {
        return Services.getText(628);
    }

    @Override
    protected void handleErrorForSavedSending(String SendingId, Throwable e2) {
        this.log(e2, Services.getText(884));
    }

    @Override
    protected boolean cancelExecute(Sending backgroundSending) {
        return false;
    }
}

