/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.edecmail;

import ch.e_dec.xml.schema.edecresponse.v4.GoodsDeclarationAcceptanceType;
import ch.e_dec.xml.schema.edecresponse.v4.GoodsDeclarationStatusType;
import ch.e_dec.xml.schema.edecresponse.v4.GoodsDeclarationsResponse;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.SendingManipJobBase;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerManagementFacade;
import ch.transsoft.edec.service.webservices.customermgmt.StatusMailState;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class PollStatusEmailJob
extends SendingManipJobBase {
    private final String guid;
    private final String customsDeclarationNumber;

    public PollStatusEmailJob(String sendingId, String guid, String customsDeclarationNumber) {
        super(sendingId);
        this.guid = guid;
        this.customsDeclarationNumber = customsDeclarationNumber;
    }

    @Override
    protected boolean cancelExecute(Sending backgroundSending) throws Exception {
        return this.isSendingInConflict();
    }

    @Override
    protected ISendingManip doExecute(Sending backgroundSending) throws Exception {
        StatusMailState message = CustomerManagementFacade.pollStatusEmail(this.guid, this.customsDeclarationNumber);
        GoodsDeclarationsResponse xml = DocumentUtil.unmarshall(GoodsDeclarationsResponse.class, message.getXmlMessageBytes());
        this.handlePdf(message.getPdfMessageBytes());
        return sending -> {
            sending.addHistoryEntry("StatusEmail received");
            if (!xml.getGoodsDeclarationStatus().isEmpty()) {
                this.handle(xml.getGoodsDeclarationStatus().get(0), sending);
            }
            if (!xml.getGoodsDeclarationAcceptance().isEmpty()) {
                this.handle(xml.getGoodsDeclarationAcceptance().get(0), sending);
            }
        };
    }

    private void handlePdf(byte[] pdf) throws IOException {
        if (pdf == null || pdf.length == 0) {
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(pdf);
        File file = SendingUtil.getAlPath(this.getSendingId(), false);
        FileUtil.copy((InputStream)in, file);
    }

    private void handle(GoodsDeclarationStatusType status, Sending sending) {
        sending.setStatus(status.getStatus().intValue());
        if (sending.getState().getStatus() != 211) {
            return;
        }
        Date acceptanceDate = DateUtil.getTimestamp(status.getStatusDate(), status.getStatusTime());
        sending.getAcceptanceDate().setValue(acceptanceDate, true);
    }

    private void handle(GoodsDeclarationAcceptanceType accept, Sending sending) {
        sending.setCustomsDeclarationVersion(accept.getCustomsDeclarationVersion().longValue());
        Date acceptanceDate = DateUtil.getTimestamp(accept.getAcceptanceDate(), accept.getAcceptanceTime());
        sending.getAcceptanceDate().setValue(acceptanceDate, true);
    }

    @Override
    public String getMessage() {
        return Services.getText(813);
    }

    @Override
    protected void handleErrorForCurrentSending(Sending sending, Throwable e2) {
        Services.get(ILoggingService.class).logAndReport(e2, Services.getText(814));
    }

    @Override
    protected void handleErrorForSavedSending(String sendingId, Throwable e2) {
        Services.get(ILoggingService.class).logSilent(e2, "Error retrieving StatusEmail");
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

