/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evv;

import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evv.FetchEvvJob;
import ch.transsoft.edec.service.backend.jobs.evv.FetchEvvJobErrorHandler;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.index.sending.IIndexService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FetchAllEvvJob
extends BackendJobBase {
    private final List<IndexEntry> indexEntryList = new ArrayList<IndexEntry>();
    private final FetchEvvJobErrorHandler errorHandler;
    private final Index index;

    public FetchAllEvvJob(boolean silent) {
        super(IConfigService.Module.moduleExport);
        this.errorHandler = new FetchEvvJobErrorHandler(silent);
        String uid = Services.get(IConfigService.class).getEdecExportIdentification();
        Check.assertFalse(uid.isEmpty(), Services.getText(815));
        this.index = (Index)Services.get(IIndexService.class).getCachedIndex();
    }

    @Override
    public void done() {
        for (IndexEntry current : this.indexEntryList) {
            FetchEvvJob job = new FetchEvvJob(current.getOperatingModeValue(), current.getSendingId(), current.getCustomsDeclarationNumber().getValue(), true);
            Services.get(IBackendService.class).put(job, true);
        }
    }

    @Override
    public void execute() throws Exception {
        if (this.index == null) {
            Services.get(ILoggingService.class).logSilent("Index not yet cached when fetching eVV");
            return;
        }
        Date cutOffDate = DateUtil.getDateOffset(new Date(), -2);
        for (IndexEntry current : this.index.getEntryList()) {
            if (!current.getCustomsDeclarationNumber().isInitialized() || !current.getState().hasAl() || current.getState().hasEvv() || current.getOperatingModeValue() != OperatingMode.production || current.getTransmissionDate().isInitialized() && current.getTransmissionDate().getValue().after(cutOffDate)) continue;
            this.indexEntryList.add(current);
        }
    }

    @Override
    public String getMessage() {
        return Services.getText(818);
    }

    @Override
    public boolean needsLocking() {
        return false;
    }

    @Override
    public boolean locksActions() {
        return false;
    }

    @Override
    public void handleError(Throwable e2) {
        this.errorHandler.handleError(e2);
    }
}

