/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.index.bordereau.IBordereauService;
import ch.transsoft.edec.util.Check;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArchiveMultipleBordereauxJob
extends BackendJobBase {
    private List<BordereauEntry> entries;
    protected volatile BordereauIndex index;
    private volatile Map<Integer, BordereauIndex> archives = new HashMap<Integer, BordereauIndex>();
    private volatile Set<BordereauEntry> bordereauxToArchive = new HashSet<BordereauEntry>();
    private List<Exception> exceptions = new ArrayList<Exception>();

    public ArchiveMultipleBordereauxJob(List<BordereauEntry> entries) {
        super(IConfigService.Module.moduleImport);
        Check.assertNotNull(entries);
        this.entries = entries;
    }

    @Override
    public void done() {
        if (!this.entries.isEmpty()) {
            Services.get(IBordereauService.class).indexChanged(this.index);
            for (Map.Entry<Integer, BordereauIndex> archive : this.archives.entrySet()) {
                Services.get(IBordereauService.class).archiveChanged(archive.getKey(), archive.getValue());
            }
        }
        if (!this.exceptions.isEmpty()) {
            this.log(this.exceptions.get(0), this.exceptions.size() + " " + Services.getText(600) + ":");
        }
    }

    @Override
    public String getMessage() {
        return Services.getText(1424);
    }

    @Override
    public void execute() throws Exception {
        this.index = IndexUtil.readBordereauIndex();
        if (this.entries.isEmpty()) {
            return;
        }
        for (BordereauEntry bordereauEntry : this.entries) {
            this.archiveBordereauEntry(bordereauEntry);
        }
        IndexUtil.writeBordereauIndex(this.index);
        for (Map.Entry entry : this.archives.entrySet()) {
            IndexUtil.writeBordereauArchive((Integer)entry.getKey(), (BordereauIndex)entry.getValue());
        }
    }

    private void archiveBordereauEntry(BordereauEntry current) throws Exception {
        try {
            BordereauInfo bordereau = this.readBordereauInfo(current);
            bordereau.getArchive().setValue(true);
            this.saveBordereauInfo(bordereau);
        }
        catch (Exception e2) {
            this.exceptions.add(e2);
            return;
        }
        this.index.removeIndexEntry(current);
        this.getArchive(current.getYear()).updateIndexEntry(current);
    }

    public BordereauIndex getArchive(int year) throws Exception {
        BordereauIndex result = this.archives.get(year);
        if (result == null) {
            result = IndexUtil.readBordereauArchive(year);
            this.archives.put(year, result);
        }
        return result;
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(861));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

