/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.FetchBordereauErrorHandler;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.FetchBordereauJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.CreateImportSendingJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class CalculateBordereauListJob
extends BackendJobBase {
    private volatile FetchBordereauErrorHandler errorHandler;
    private volatile String spediteurNumber;
    private final OperatingMode mode;
    private final List<IEZVService.BordereauListEntry> bordereauSourceList;
    private final List<IEZVService.BordereauListEntry> bordereauTargetList = new ArrayList<IEZVService.BordereauListEntry>();
    private final List<Integer> years = DateUtil.getYearsBackFrom(new Date(), 2);
    private final boolean silent;

    public CalculateBordereauListJob(ArrayList<IEZVService.BordereauListEntry> bordereauList, String spediteurNumber, OperatingMode mode, boolean silent) {
        super(IConfigService.Module.moduleImport);
        this.bordereauSourceList = bordereauList;
        this.spediteurNumber = spediteurNumber;
        this.mode = mode;
        this.silent = silent;
        this.errorHandler = new FetchBordereauErrorHandler(silent);
    }

    @Override
    public void done() {
        if (!this.bordereauTargetList.isEmpty()) {
            Services.get(IGuiService.class).selectImportTab(GuiService.ImportTab.bordereau, null);
        }
        for (IEZVService.BordereauListEntry current : this.bordereauTargetList) {
            Services.get(IBackendService.class).put(new FetchBordereauJob(this.spediteurNumber, this.mode, current, this.silent), true);
        }
        Services.get(IBackendService.class).put(new CreateImportSendingJob(this.spediteurNumber, this.mode, this.silent), true);
    }

    @Override
    public void execute() throws Exception {
        HashSet<String> existing = new HashSet<String>();
        BordereauIndex index = IndexUtil.readBordereauIndex();
        this.addExisting(index, existing);
        for (Integer n : this.years) {
            this.addExisting(IndexUtil.readBordereauArchive(n), existing);
        }
        for (IEZVService.BordereauListEntry bordereauListEntry : this.bordereauSourceList) {
            if (existing.contains(bordereauListEntry.getBordereauNumberStr())) continue;
            this.bordereauTargetList.add(bordereauListEntry);
        }
    }

    private void addExisting(BordereauIndex index, HashSet<String> existing) {
        for (BordereauEntry current : index.getEntryList()) {
            existing.add(current.getBordereauNumber().getValue());
        }
    }

    @Override
    public String getMessage() {
        return Services.getText(1430);
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public boolean locksActions() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.errorHandler.handleError(e2);
    }
}

