/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.BordereauArchiveUpdate;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.BordereauIndexUpdate;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.IBordereauIndexUpdater;
import ch.transsoft.edec.service.config.IConfigService;

public class ChangeBordereauInvoiceNumberJob
extends BackendJobBase {
    private volatile IBordereauIndexUpdater indexUpdater;
    private BordereauEntry entry;
    private String mInvoiceNumber;
    private String zInvoiceNumber;

    public ChangeBordereauInvoiceNumberJob(BordereauEntry entry, String mInvoiceNumber, String zInvoiceNumber) {
        super(IConfigService.Module.moduleImport);
        this.entry = entry;
        this.mInvoiceNumber = mInvoiceNumber;
        this.zInvoiceNumber = zInvoiceNumber;
    }

    @Override
    public void done() {
        this.indexUpdater.notifyChange();
    }

    @Override
    public void execute() throws Exception {
        BordereauInfo bordereau = this.readBordereauInfo(this.entry);
        if (this.mInvoiceNumber != null) {
            bordereau.getMInvoice().setValue(this.mInvoiceNumber);
        }
        if (this.zInvoiceNumber != null) {
            bordereau.getZInvoice().setValue(this.zInvoiceNumber);
        }
        this.saveBordereauInfo(bordereau);
        this.indexUpdater = bordereau.getArchive().getValue() != false ? new BordereauArchiveUpdate(bordereau.createBordereauEntry()) : new BordereauIndexUpdate(bordereau.createBordereauEntry());
        this.indexUpdater.saveOrUpdateIndex();
    }

    @Override
    public String getMessage() {
        return Services.getText(1435);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, new String[0]);
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

