/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.e_dec.services.edecbordereauservice.v1.BordereauRequestFault;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.ezv.bordereau.BordereauErrorHandler;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.Check;
import jakarta.xml.ws.WebServiceException;
import java.net.ConnectException;
import java.net.UnknownHostException;

public class FetchBordereauErrorHandler {
    private final boolean silent;

    public FetchBordereauErrorHandler(boolean silent) {
        this.silent = silent;
    }

    public void handleError(Throwable e2) {
        if (this.silent) {
            Services.get(ILoggingService.class).logSilent(e2, "Error while fetching Bordereau");
            return;
        }
        if (e2 instanceof WebServiceException) {
            if (e2.getCause() instanceof UnknownHostException) {
                Services.get(ILoggingService.class).logAndReport(e2.getCause(), Services.getText(627) + "\n" + Services.getText(623));
                return;
            }
            if (e2.getCause() instanceof ConnectException) {
                Services.get(ILoggingService.class).logAndReport(e2.getCause(), Services.getText(627) + "\n" + Services.getText(623));
                return;
            }
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(627) + "\n" + Services.getText(623));
            return;
        }
        if (e2 instanceof BordereauRequestFault) {
            new BordereauErrorHandler((BordereauRequestFault)e2);
        } else {
            Check.fail(e2, Services.getText(888));
        }
    }
}

