/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauFetchInfo;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.CalculateBordereauListJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.FetchBordereauErrorHandler;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FetchBordereauListJob
extends BackendJobBase {
    private volatile FetchBordereauErrorHandler errorHandler;
    private volatile String importID;
    private volatile List<String> accountNumbers;
    private volatile OperatingMode mode;
    private ArrayList<IEZVService.BordereauListEntry> bordereauList;
    private final boolean silent;

    public FetchBordereauListJob(boolean silent) {
        super(IConfigService.Module.moduleImport);
        this.silent = silent;
        this.errorHandler = new FetchBordereauErrorHandler(silent);
        this.importID = Services.get(IConfigService.class).getEdecImportIdentification();
        this.accountNumbers = Services.get(IConfigService.class).getAccountNumbers();
        this.mode = Services.get(IConfigService.class).getOperatingModeForActiveModule();
    }

    @Override
    public void done() {
        Services.get(IBackendService.class).put(new CalculateBordereauListJob(this.bordereauList, this.importID, this.mode, this.silent), true);
    }

    @Override
    public void execute() throws Exception {
        this.bordereauList = new ArrayList();
        for (String accountNumber : this.accountNumbers) {
            if (accountNumber.isEmpty()) continue;
            this.getBordereauListEntries(accountNumber);
        }
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    private void getBordereauListEntries(String accountNumber) throws Exception {
        Date startDate = this.getStartDate(accountNumber);
        Date endDate = new Date();
        List<DateUtil.DateRange> ranges = DateUtil.getRanges(startDate, endDate, 10);
        for (DateUtil.DateRange current : ranges) {
            Services.get(IEZVService.class).getBordereauList(this.mode, this.importID, accountNumber, current.start, current.end, false, this.bordereauList);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (DateUtil.getAge(current.end) <= 20) continue;
            BordereauFetchInfo fetchInfo = this.readBordereauFetchInfo();
            fetchInfo.updateLastFetchDate(accountNumber, new EdecDateNode(DateUtil.formatEzvDate(current.end)));
            this.saveBordereauFetchInfo(fetchInfo);
        }
    }

    private Date getStartDate(String accountNumber) throws Exception {
        BordereauFetchInfo fetchInfo = this.readBordereauFetchInfo();
        Date lastFetchDate = fetchInfo.getlastFetchDate(accountNumber);
        if (lastFetchDate != null) {
            return lastFetchDate;
        }
        return Services.get(IConfigService.class).getLicenseInfo().getEvvImportStartDate().getValue();
    }

    @Override
    public String getMessage() {
        return Services.getText(1431);
    }

    @Override
    public boolean needsLocking() {
        return false;
    }

    @Override
    public boolean locksActions() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.errorHandler.handleError(e2);
    }
}

