/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.model.evvimport.bordereau.ReceiptDesc;
import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.evv.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShowMultiBordereauAsPdfJob
extends BackendJobBase {
    private final BordereauEntry entry;
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private final Map<String, ImportSendingList> importSendingListCache = new HashMap<String, ImportSendingList>();

    public ShowMultiBordereauAsPdfJob(BordereauEntry entry) {
        super(IConfigService.Module.moduleImport);
        this.entry = entry;
    }

    @Override
    public void done() {
        try {
            DocumentUtil.showPdf(this.bos.toByteArray(), "bordereau");
        }
        catch (IOException e2) {
            this.log(e2, "Failed to show multi-page bordereau");
        }
    }

    @Override
    public void execute() throws Exception {
        List<Integer> years = DateUtil.getYearsBackFrom(new Date(), 2);
        HashMap<ImportSendingKey, ReceiptEntry> receipts = new HashMap<ImportSendingKey, ReceiptEntry>();
        ReceiptIndex index = IndexUtil.readReceiptIndex();
        this.addExisting(index, receipts);
        for (Integer current : years) {
            this.addExisting(IndexUtil.readReceiptArchive(current), receipts);
        }
        PdfWriter writer = new PdfWriter();
        BordereauInfo bordereauInfo = this.readBordereauInfo(this.entry);
        ByteArrayInputStream bis = new ByteArrayInputStream(bordereauInfo.getData().getByteArray());
        writer.addBordereau(bis, this.bos);
        String date = bordereauInfo.getDocumentDate();
        for (ReceiptDesc current : bordereauInfo.getReceiptDescs()) {
            ImportSending importSending;
            ReceiptDocument doc;
            ImportSendingKey key = new ImportSendingKey(current.getCustomsReferenceNumberStr(), date);
            ReceiptEntry receiptEntry = (ReceiptEntry)receipts.get(key);
            if (receiptEntry == null || !(doc = (importSending = this.getImportSending(receiptEntry)).getReceiptDocument(current.getType().getValue())).hasDocument()) continue;
            writer.addReceipt(doc.getData().asInputStream());
        }
        writer.finish();
    }

    private ImportSending getImportSending(ReceiptEntry indexEntry) throws Exception {
        ImportSendingList list = this.getImportSendingList(indexEntry.getDate());
        return list.getImportSending(indexEntry.getKey());
    }

    private ImportSendingList getImportSendingList(EdecDateNode date) throws Exception {
        ImportSendingList result = this.importSendingListCache.get(date.getValue());
        if (result == null) {
            result = this.readImportSendingList(date);
            this.importSendingListCache.put(date.getValue(), result);
        }
        return result;
    }

    private void addExisting(ReceiptIndex index, Map<ImportSendingKey, ReceiptEntry> receipts) {
        for (ReceiptEntry current : index.getEntryList()) {
            receipts.put(current.getKey(), current);
        }
    }

    @Override
    public String getMessage() {
        return Services.getText(1438);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, "Error loading Bordereau");
    }

    @Override
    public boolean locksActions() {
        return false;
    }

    @Override
    public boolean skipAfterShutdown() {
        return true;
    }

    @Override
    public boolean showWaitCursor() {
        return true;
    }
}

