/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.model.evvimport.bordereau.ReceiptDesc;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.SaveBordereauJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdateBordereauStateJob
extends BackendJobBase {
    private final List<BordereauInfo> completeBordereaus = new ArrayList<BordereauInfo>();
    private final Set<Integer> loadedYears = new HashSet<Integer>();
    private final Map<ImportSendingKey, ReceiptEntry> receipts = new HashMap<ImportSendingKey, ReceiptEntry>();

    public UpdateBordereauStateJob() {
        super(IConfigService.Module.moduleImport);
    }

    @Override
    public void done() {
        for (BordereauInfo info : this.completeBordereaus) {
            Services.get(IBackendService.class).put(new SaveBordereauJob(info), true);
        }
    }

    @Override
    public void execute() throws Exception {
        this.addReceipts(IndexUtil.readReceiptIndex());
        BordereauIndex index = IndexUtil.readBordereauIndex();
        for (BordereauEntry current : index.getEntryList()) {
            if (current.getComplete().getValue().booleanValue()) continue;
            this.checkBordereauComplete(this.readBordereauInfo(current));
        }
    }

    private void addReceipts(ReceiptIndex receiptIndex) {
        for (ReceiptEntry current : receiptIndex.getEntryList()) {
            this.receipts.put(current.getKey(), current);
        }
    }

    private void checkBordereauComplete(BordereauInfo info) {
        Check.assertTrue(info.getCreationDate().isInitialized(), "Create date not initialized for bordereau" + info.getBordereauNumberStr());
        for (Integer year : DateUtil.getYearsBackFrom(info.getCreationDate().getYear(), 2)) {
            if (this.loadedYears.contains(year)) continue;
            this.addReceipts(IndexUtil.readReceiptArchive(year));
            this.loadedYears.add(year);
        }
        if (this.bordereauContainsAllReceipts(info)) {
            info.getComplete().setValue(true);
            this.completeBordereaus.add(info);
        }
    }

    private boolean bordereauContainsAllReceipts(BordereauInfo info) {
        for (ReceiptDesc current : info.getReceiptDescs()) {
            ReceiptEntry receiptEntry = this.receipts.get(new ImportSendingKey(current.getCustomsReferenceNumberStr(), info.getDocumentDate()));
            if (receiptEntry == null) {
                return false;
            }
            if (receiptEntry.containsReceiptDocumentOrError(current.getType().getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getMessage() {
        return Services.getText(4430);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, new String[0]);
    }

    @Override
    public boolean skipAfterShutdown() {
        return true;
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

