/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.index.receipt.IReceiptService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractArchiveReceiptsJob
extends BackendJobBase {
    protected volatile ReceiptIndex index;
    private volatile Map<Integer, ReceiptIndex> archives = new HashMap<Integer, ReceiptIndex>();
    private volatile Map<String, ImportSendingList> importSendingLists = new HashMap<String, ImportSendingList>();
    private volatile Set<ReceiptEntry> receiptsToArchive = new HashSet<ReceiptEntry>();
    private List<Exception> exceptions = new ArrayList<Exception>();

    public AbstractArchiveReceiptsJob() {
        super(IConfigService.Module.moduleImport);
    }

    @Override
    public void done() {
        if (!this.receiptsToArchive.isEmpty()) {
            Services.get(IReceiptService.class).indexChanged(this.index);
            for (Map.Entry<Integer, ReceiptIndex> archive : this.archives.entrySet()) {
                Services.get(IReceiptService.class).archiveChanged(archive.getKey(), archive.getValue());
            }
        }
        if (!this.exceptions.isEmpty()) {
            this.log(this.exceptions.get(0), this.exceptions.size() + " " + Services.getText(600) + ":");
        }
    }

    @Override
    public String getMessage() {
        return Services.getText(1424);
    }

    @Override
    public void execute() throws Exception {
        this.index = IndexUtil.readReceiptIndex();
        this.receiptsToArchive = this.getReceiptsToArchive();
        if (this.receiptsToArchive.isEmpty()) {
            return;
        }
        for (ReceiptEntry receiptEntry : this.receiptsToArchive) {
            this.archiveReceiptEntry(receiptEntry);
        }
        IndexUtil.writeReceiptIndex(this.index);
        for (Map.Entry entry : this.archives.entrySet()) {
            IndexUtil.writeReceiptArchive((Integer)entry.getKey(), (ReceiptIndex)entry.getValue());
        }
        for (ImportSendingList importSendingList : this.importSendingLists.values()) {
            this.saveImportSendingList(importSendingList);
        }
    }

    protected abstract Set<ReceiptEntry> getReceiptsToArchive();

    private void archiveReceiptEntry(ReceiptEntry current) throws Exception {
        try {
            ImportSending importSending = this.getImportSending(current.getDate(), current.getKey());
            importSending.getArchive().setValue(true);
        }
        catch (Exception e2) {
            this.exceptions.add(e2);
            return;
        }
        this.index.removeIndexEntry(current);
        this.getArchive(current.getDate().getYear()).addEntry(current);
    }

    private ImportSending getImportSending(EdecDateNode date, ImportSendingKey key) throws Exception {
        ImportSendingList importSendingList = this.importSendingLists.get(date.getValue());
        if (importSendingList == null) {
            importSendingList = this.readImportSendingList(date);
            this.importSendingLists.put(date.getValue(), importSendingList);
        }
        return importSendingList.getImportSending(key);
    }

    public ReceiptIndex getArchive(int year) throws Exception {
        ReceiptIndex result = this.archives.get(year);
        if (result == null) {
            result = IndexUtil.readReceiptArchive(year);
            this.archives.put(year, result);
        }
        return result;
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(861));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

