/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.e_dec.xml.schema.edecreceiptresponse.v3.ReceiptRequestResponse;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauFetchInfo;
import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.SafeTransactionReporter;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.AbstractReceiptAddingJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptFetchingUpdate;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import javax.xml.datatype.XMLGregorianCalendar;

public class AddReceiptJob
extends AbstractReceiptAddingJob {
    private final ReceiptEntry entry;
    private final ImportSendingKey key;
    private final String bordereauNumber;
    private final XMLGregorianCalendar documentCreationDate;
    private final ReceiptRequestResponse response;
    private final ReceiptPm receiptPm;
    private final String account;

    public AddReceiptJob(ReceiptFetchingUpdate update, ReceiptPm receiptPm) {
        super(update.getResponse().getSoapMessage(), update.getReceiptDocumentType());
        this.receiptPm = receiptPm;
        this.entry = update.getEntry();
        this.key = update.getKey();
        this.bordereauNumber = update.getBordereauNumber();
        this.documentCreationDate = update.getDocumentCreationDate();
        this.response = update.getResponse().getResponse();
        this.account = update.getAccount();
    }

    @Override
    protected EdecDateNode getDocumentDate() {
        return this.toEdecDateNode(this.documentCreationDate);
    }

    @Override
    protected String getBordereauNumberStr() {
        return this.bordereauNumber;
    }

    private EdecDateNode toEdecDateNode(XMLGregorianCalendar documentDate) {
        return new EdecDateNode(DateUtil.toEdecDateString(documentDate));
    }

    @Override
    protected void setDeclarationType(IntegralNode declarationType) {
        switch (this.getDocumentType()) {
            case vvz: {
                declarationType.setValue(this.response.getTaxationDecisionCustomsDuties().getDeclarationType().longValue());
                break;
            }
            case vvm: {
                declarationType.setValue(this.response.getTaxationDecisionVAT().getDeclarationType().longValue());
                break;
            }
            case rbz: {
                break;
            }
            case rbm: {
                break;
            }
            default: {
                Check.fail("Unexpected ReceiptType " + this.getDocumentType());
            }
        }
    }

    @Override
    public void done() {
        this.notifyChange();
    }

    @Override
    public void execute() throws Exception {
        this.addReceiptToImportSending(this.key, this.entry, ImportSending.ReceiptSource.download);
        String guid = Services.get(IConfigService.class).getGuid();
        SafeTransactionReporter.saveReportTransactionImport(guid, this.key.getCustomsReferenceNumber(), true);
        BordereauFetchInfo fetchInfo = this.readBordereauFetchInfo();
        fetchInfo.updateLastFetchDate(this.account, this.getDocumentDate());
        this.saveBordereauFetchInfo(fetchInfo);
    }

    @Override
    public String getMessage() {
        return Services.getText(879);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(880));
    }

    @Override
    public boolean locksActions() {
        return true;
    }

    @Override
    protected void reportNewlyCreatedImportSending(ImportSending importSending) {
        this.receiptPm.reportNewlyCreatedImportSending(importSending.createReceiptEntry());
    }
}

