/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.model.evvimport.bordereau.ReceiptDesc;
import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.AutoArchiveJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.UpdateBordereauStateJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.FetchReceiptJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ReceiptFetchDescription;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.index.receipt.IReceiptService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateImportSendingJob
extends BackendJobBase {
    private final Map<ImportSendingKey, ReceiptEntry> receiptEntries = new HashMap<ImportSendingKey, ReceiptEntry>();
    private final List<ReceiptFetchDescription> fetchDescs = new ArrayList<ReceiptFetchDescription>();
    private ReceiptIndex receiptIndex;
    private final String spediteurNumber;
    private final OperatingMode mode;
    private final boolean silent;

    public CreateImportSendingJob(String spediteurNumber, OperatingMode mode, boolean silent) {
        super(IConfigService.Module.moduleImport);
        this.spediteurNumber = spediteurNumber;
        this.mode = mode;
        this.silent = silent;
    }

    @Override
    public void done() {
        Services.get(IReceiptService.class).indexChanged(this.receiptIndex);
        String guid = Services.get(IConfigService.class).getGuid();
        for (ReceiptFetchDescription fetchDesc : this.fetchDescs) {
            Services.get(IBackendService.class).put(new FetchReceiptJob(guid, this.spediteurNumber, this.mode, fetchDesc, this.silent), true);
        }
        Services.get(IBackendService.class).put(new UpdateBordereauStateJob(), true);
        Services.get(IBackendService.class).put(new AutoArchiveJob());
        if (!this.fetchDescs.isEmpty()) {
            Services.get(IGuiService.class).selectImportTab(GuiService.ImportTab.receipts, null);
        }
    }

    @Override
    public void execute() throws Exception {
        this.receiptIndex = IndexUtil.readReceiptIndex();
        BordereauIndex bordereauIndex = IndexUtil.readBordereauIndex();
        this.readReceiptEntries(bordereauIndex);
        for (BordereauEntry bordereauEntry : bordereauIndex.getEntryList()) {
            this.handle(bordereauEntry);
        }
        IndexUtil.writeReceiptIndex(this.receiptIndex);
    }

    private void handle(BordereauEntry bordereauEntry) throws Exception {
        BordereauInfo info = this.readBordereauInfo(bordereauEntry);
        for (ReceiptDesc receiptDesc : info.getReceiptDescs()) {
            this.handle(receiptDesc, info);
        }
    }

    private void handle(ReceiptDesc receiptDesc, BordereauInfo bordereauInfo) {
        ImportSendingKey key = new ImportSendingKey(receiptDesc.getCustomsReferenceNumberStr(), bordereauInfo.getDocumentDate());
        ReceiptEntry entry = this.receiptEntries.get(key);
        if (entry != null) {
            this.handle(entry, receiptDesc, bordereauInfo);
        } else {
            ImportSendingList importSendingList = this.readOrCreateImportSendingList(bordereauInfo.getCreationDate());
            ImportSending existingSending = importSendingList.getImportSending(key);
            if (existingSending != null) {
                entry = existingSending.createReceiptEntry();
                this.handle(entry, receiptDesc, bordereauInfo);
                this.receiptIndex.getEntryList().add(entry);
            } else {
                ImportSending importSending = this.createImportSending(receiptDesc, bordereauInfo);
                importSendingList.add(importSending);
                this.saveImportSendingList(importSendingList);
                ReceiptEntry receiptEntry = importSending.createReceiptEntry();
                this.receiptIndex.getEntryList().add(receiptEntry);
                this.receiptEntries.put(receiptEntry.getKey(), receiptEntry);
                this.fetchDescs.add(new ReceiptFetchDescription(receiptDesc, bordereauInfo));
            }
        }
    }

    private ImportSendingList readOrCreateImportSendingList(EdecDateNode date) {
        try {
            return this.readImportSendingList(date);
        }
        catch (Exception e2) {
            ImportSendingList result = NodeFactory.create(ImportSendingList.class);
            result.getDate().apply(date);
            return result;
        }
    }

    private ImportSending createImportSending(ReceiptDesc receiptDesc, BordereauInfo bordereauInfo) {
        ImportSending result = NodeFactory.create(ImportSending.class);
        result.getCustomsReferenceNumber().apply(receiptDesc.getCustomsReferenceNumber());
        result.getBordereauNumber().apply(bordereauInfo.getBordereauNumber());
        Check.assertTrue(bordereauInfo.getCreationDate().isInitialized(), "Create date not initialized for bordereau" + bordereauInfo.getBordereauNumberStr());
        result.getDate().apply(bordereauInfo.getCreationDate());
        return result;
    }

    private void handle(ReceiptEntry entry, ReceiptDesc receiptDesc, BordereauInfo bordereauInfo) {
        if (!this.containsReceipt(entry, receiptDesc)) {
            this.fetchDescs.add(new ReceiptFetchDescription(receiptDesc, bordereauInfo));
        }
    }

    private boolean containsReceipt(ReceiptEntry entry, ReceiptDesc receiptDesc) {
        return entry.containsReceiptDocument(receiptDesc.getType().getValue());
    }

    private void readReceiptEntries(BordereauIndex bordereauIndex) {
        this.addReceiptEntries(this.receiptIndex);
        int numberOfYears = this.getBordereauYearRange(bordereauIndex);
        for (int year : DateUtil.getYearsBackFrom(new Date(), numberOfYears)) {
            this.addReceiptEntries(IndexUtil.readReceiptArchive(year));
        }
    }

    private int getBordereauYearRange(BordereauIndex bordereauIndex) {
        int currentYear;
        int oldest = currentYear = DateUtil.getCurrentYear();
        for (BordereauEntry entry : bordereauIndex.getEntryList()) {
            oldest = Math.min(oldest, entry.getCreationDate().getYear());
        }
        return currentYear - oldest + 2;
    }

    private void addReceiptEntries(ReceiptIndex index) {
        for (ReceiptEntry current : index.getEntryList()) {
            this.receiptEntries.put(current.getKey(), current);
        }
    }

    @Override
    public String getMessage() {
        return Services.getText(1433);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, "Failed to create Import Sendings");
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

