/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.IReceiptIndexUpdater;
import ch.transsoft.edec.service.index.receipt.IReceiptService;

public class ReceiptArchiveUpdate
implements IReceiptIndexUpdater {
    private int year;
    private ReceiptIndex index;
    private final ReceiptEntry indexEntry;

    public ReceiptArchiveUpdate(ReceiptEntry indexEntry) {
        this.indexEntry = indexEntry;
        this.year = indexEntry.getYear();
    }

    @Override
    public void notifyChange() {
        Services.get(IReceiptService.class).archiveChanged(this.year, this.index);
    }

    @Override
    public void saveOrUpdateIndex() throws Exception {
        this.index = IndexUtil.readReceiptArchive(this.year);
        this.index.updateIndexEntry(this.indexEntry);
        IndexUtil.writeReceiptArchive(this.year, this.index);
    }

    @Override
    public void deleteEntry() throws Exception {
        this.index = IndexUtil.readReceiptArchive(this.year);
        this.index.removeIndexEntry(this.indexEntry);
        IndexUtil.writeReceiptArchive(this.year, this.index);
    }
}

