/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.IReceiptIndexUpdater;
import ch.transsoft.edec.service.index.receipt.IReceiptService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.File;

public class ReceiptIndexUpdate
implements IReceiptIndexUpdater {
    private volatile ReceiptIndex index;
    private final ReceiptEntry indexEntry;

    public ReceiptIndexUpdate(ReceiptEntry indexEntry) {
        this.indexEntry = indexEntry;
    }

    @Override
    public void notifyChange() {
        if (this.index == null) {
            return;
        }
        Services.get(IReceiptService.class).indexChanged(this.index);
    }

    @Override
    public void saveOrUpdateIndex() throws Exception {
        ImportSendingList importSendingList = this.readImportSendingList(this.indexEntry.getDate());
        ImportSending importSending = importSendingList.getImportSending(this.indexEntry.getKey());
        if (importSending == null) {
            Services.get(ILoggingService.class).logSilentWithBugMail(new NullPointerException(), "Importsending " + this.indexEntry.getCustomsReferenceNumberStr() + " is not in sendingList " + this.indexEntry.getDate());
            return;
        }
        if (this.indexEntry.hasVvm() && !importSending.getVvm().hasDocument()) {
            this.indexEntry.setVvm(ReceiptDocument.State.DOC_NOT_RECEIVED.asIntegralNode());
            Services.get(ILoggingService.class).logSilentWithBugMail(new NullPointerException(), "Importsending " + this.indexEntry.getCustomsReferenceNumberStr() + " with date " + this.indexEntry.getDate() + " has no VVM");
        }
        if (this.indexEntry.hasVvz() && !importSending.getVvz().hasDocument()) {
            this.indexEntry.setVvz(ReceiptDocument.State.DOC_NOT_RECEIVED.asIntegralNode());
            Services.get(ILoggingService.class).logSilentWithBugMail(new NullPointerException(), "Importsending " + this.indexEntry.getCustomsReferenceNumberStr() + " with date " + this.indexEntry.getDate() + " has no VVZ");
        }
        if (this.indexEntry.hasRbm() && !importSending.getRbm().hasDocument()) {
            this.indexEntry.setRbm(ReceiptDocument.State.DOC_NOT_RECEIVED.asIntegralNode());
            Services.get(ILoggingService.class).logSilentWithBugMail(new NullPointerException(), "Importsending " + this.indexEntry.getCustomsReferenceNumberStr() + " with date " + this.indexEntry.getDate() + " has no RBM");
        }
        if (this.indexEntry.hasRbz() && !importSending.getRbz().hasDocument()) {
            this.indexEntry.setRbz(ReceiptDocument.State.DOC_NOT_RECEIVED.asIntegralNode());
            Services.get(ILoggingService.class).logSilentWithBugMail(new NullPointerException(), "Importsending " + this.indexEntry.getCustomsReferenceNumberStr() + " with date " + this.indexEntry.getDate() + " has no RBZ");
        }
        this.index = IndexUtil.readReceiptIndex();
        this.index.updateIndexEntry(this.indexEntry);
        IndexUtil.writeReceiptIndex(this.index);
    }

    private ImportSendingList readImportSendingList(EdecDateNode date) throws Exception {
        File file = SendingUtil.getImportSendingListPathWithoutExtension(date, false);
        return FileUtil.readFile(file, ImportSendingList.class);
    }

    @Override
    public void deleteEntry() throws Exception {
        this.index = IndexUtil.readReceiptIndex();
        this.index.removeIndexEntry(this.indexEntry);
        IndexUtil.writeReceiptIndex(this.index);
    }
}

