/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.outlook.IOutlookService;
import ch.transsoft.edec.service.webservices.mail.CarrierMail;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;

public final class SendMailToImporteurViaOutlookJob
extends BackendJobBase {
    private final ListNode<AttachmentEntry> attachments;
    private final CarrierMail mail;
    private final ReceiptEntry entry;
    private ImportSending sending;

    public SendMailToImporteurViaOutlookJob(ReceiptEntry entry, CarrierMail mail, ListNode<AttachmentEntry> attachments) {
        super(IConfigService.Module.moduleImport);
        this.entry = entry;
        this.mail = mail;
        this.attachments = attachments;
    }

    @Override
    public void done() {
    }

    @Override
    public String getMessage() {
        return Services.getText(885);
    }

    @Override
    public void execute() throws Exception {
        this.sending = this.readImportSending(this.entry);
        Services.get(IOutlookService.class).send(this.mail, this.attachments, this.sending);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(886));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

