/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.evv.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class ShowReceiptAsPdfJob
extends BackendJobBase {
    private final ReceiptEntry entry;
    private final ReceiptDocumentType type;
    private ImportSending importSending;

    public ShowReceiptAsPdfJob(ReceiptEntry entry, ReceiptDocumentType type) {
        super(IConfigService.Module.moduleImport);
        this.entry = entry;
        this.type = type;
    }

    @Override
    public void done() {
        if (this.importSending == null) {
            return;
        }
        ReceiptDocument document = this.importSending.getReceiptDocument(this.type);
        if (document.hasError()) {
            DialogUtil.showWarningDialog("Error", document.getData().getValue());
            return;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(document.getData().getByteArray());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PdfWriter.createReceipt(bis, (OutputStream)bos);
            DocumentUtil.showPdf(bos.toByteArray(), this.type.name());
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, "Failed to show receipt");
            Services.get(ILoggingService.class).logSilentWithBugMail(e2, "Failed to show importSending " + this.importSending.getCustomsReferenceNumber().getValue() + " type \"" + this.type.name() + "\" with date " + this.importSending.getDate().getValue());
        }
    }

    @Override
    public void execute() throws Exception {
        this.importSending = this.readImportSending(this.entry);
    }

    @Override
    public String getMessage() {
        return Services.getText(1465);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, "Error reading receipt");
    }

    @Override
    public boolean locksActions() {
        return false;
    }

    @Override
    public boolean skipAfterShutdown() {
        return true;
    }

    @Override
    public boolean showWaitCursor() {
        return true;
    }
}

