/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.imp;

import ch.transsoft.edec.model.infra.LoggingContext;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class TextReader {
    private static final String KEY_SENDING = "sending";
    private static final String KEY_ITEM = "goodsItem";
    private static final String DELIMITER = "\\|";
    private final Sending sending;

    public TextReader(Sending sending) {
        this.sending = sending;
    }

    private List<IPrimitive<?>> sendingFields() {
        ArrayList result = new ArrayList();
        result.add(this.sending.getGoodsDeclaration().getTraderDeclarationNumber());
        result.add(this.sending.getGoodsDeclaration().getTraderReference());
        result.add(this.sending.getGoodsDeclaration().getDeliveryDestination());
        result.add(this.sending.getGoodsDeclaration().getBusiness().getIncoterms());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getId());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getName());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getAddressSupplement1());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getAddressSupplement2());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getStreet());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getPostalCode());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getCity());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getCountry());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getVatNumber());
        result.add(this.sending.getGoodsDeclaration().getConsignee().getEoriNumber());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getId());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getName());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getAddressSupplement1());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getAddressSupplement2());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getStreet());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getPostalCode());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getCity());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getCountry());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getVatNumber());
        result.add(this.sending.getGoodsDeclaration().getDelivery().getEoriNumber());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getId());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getName());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getAddressSupplement1());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getAddressSupplement2());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getStreet());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getPostalCode());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getCity());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getCountry());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getVatNumber());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getEmail());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getPhone());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getUid());
        result.add(this.sending.getGoodsDeclaration().getConsignor().getAuthorizationNumber());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getId());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getName());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getAddressSupplement1());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getAddressSupplement2());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getStreet());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getPostalCode());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getCity());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getCountry());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getContact());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getEmail());
        result.add(this.sending.getGoodsDeclaration().getCarrier().getPhone());
        result.add(this.sending.getGoodsDeclaration().getBusiness().getInvoiceCurrency());
        result.add(this.sending.getGoodsDeclaration().getTransportMeans().getTransportMode());
        result.add(this.sending.getGoodsDeclaration().getTransportMeans().getTransportationCountry());
        return result;
    }

    private List<IPrimitive<?>> goodsItemFields() {
        ArrayList result = new ArrayList();
        GoodsItem goodsItem = NodeFactory.create(GoodsItem.class);
        this.sending.getItemList().getGoodsItems().add(goodsItem);
        result.add(goodsItem.getId());
        result.add(goodsItem.getGoodsData().getDescriptionShort());
        result.add(goodsItem.getGoodsData().getDescriptionEn());
        result.add(goodsItem.getGoodsData().getCommodityCode());
        result.add(goodsItem.getGoodsData().getStatisticalCode());
        result.add(goodsItem.getGoodsData().getGrossMass());
        result.add(goodsItem.getGoodsData().getNetMass());
        result.add(goodsItem.getGoodsData().getStatisticalValue());
        result.add(goodsItem.getGoodsData().getCurrency());
        result.add(goodsItem.getGoodsData().getCurrencyRate());
        result.add(goodsItem.getGoodsData().getQuantity());
        result.add(goodsItem.getGoodsData().getPackagingType());
        result.add(goodsItem.getGoodsData().getPackagingReferenceNumber());
        result.add(goodsItem.getGoodsData().getAdditionalUnit());
        result.add(goodsItem.getGoodsData().getRefundType());
        result.add(goodsItem.getGoodsData().getVOCQuantity());
        result.add(goodsItem.getGoodsData().getCustomsClearanceType());
        result.add(goodsItem.getGoodsData().getCommercialGood());
        result.add(goodsItem.getPermits().getPermitObligation());
        result.add(goodsItem.getNonCustomLaws().getNonCustomsLawObligation());
        result.add(goodsItem.getGoodsData().getInEur());
        result.add(goodsItem.getGoodsData().getEurInvoices());
        result.add(goodsItem.getGoodsData().getOrigin());
        return result;
    }

    public Sending read(LoggingContext context, File file) throws IOException {
        String encoding = Services.get(IConfigService.class).getOptionInfo().getImportInfo().getEncoding().getValue().getKey();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.processLine(context, line);
            }
        }
        return this.sending;
    }

    private void processLine(LoggingContext context, String line) {
        List<IPrimitive<?>> fields;
        String[] segs = line.split(DELIMITER, -1);
        if (segs.length <= 1) {
            return;
        }
        String key = segs[0].trim();
        if (key.equals(KEY_SENDING)) {
            fields = this.sendingFields();
        } else if (key.equals(KEY_ITEM)) {
            fields = this.goodsItemFields();
        } else {
            context.log(Services.getText(832) + segs[0]);
            return;
        }
        for (int i2 = 1; i2 < segs.length && i2 <= fields.size(); ++i2) {
            if (segs[i2].trim().isEmpty()) continue;
            IPrimitive<?> field = fields.get(i2 - 1);
            field.parseValue(context, segs[i2]);
            ((NodeBase)((Object)field)).setReadValue(true);
        }
        if (this.sending.getGoodsDeclaration().getDelivery().getName().isInitialized()) {
            this.sending.getGoodsDeclaration().getDelivery().setEnabled(true);
        }
    }
}

