/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.manip;

import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.manip.IIndexUpdater;
import ch.transsoft.edec.service.index.sending.IIndexService;
import ch.transsoft.edec.util.Check;

public class IndexUpdate
implements IIndexUpdater {
    private volatile Index index;
    private volatile IndexEntry indexEntry;

    public IndexUpdate(IndexEntry indexEntry) {
        this.indexEntry = indexEntry;
    }

    @Override
    public void notifyChange() {
        Check.assertNotNull(this.index);
        Services.get(IIndexService.class).indexChanged(this.index);
    }

    @Override
    public void saveOrUpdateIndex() throws Exception {
        this.index = IndexUtil.readIndex();
        this.index.updateIndexEntry(this.indexEntry);
        IndexUtil.writeIndex(this.index);
    }

    @Override
    public void deleteEntry() throws Exception {
        this.index = IndexUtil.readIndex();
        this.index.removeIndexEntry(this.indexEntry);
        IndexUtil.writeIndex(this.index);
    }
}

