/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.sending;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.SendingManipJobBase;

public class ClearSendingStatusJob
extends SendingManipJobBase {
    private final String traderDeclarationNumber;

    public ClearSendingStatusJob(String sendingId, String traderDeclarationNumber) {
        super(sendingId);
        this.traderDeclarationNumber = traderDeclarationNumber;
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    protected ISendingManip doExecute(Sending backgroundSending) throws Exception {
        return sending -> {
            sending.getState().clearStatus();
            sending.addHistoryEntry("Status manually set to " + sending.getState().getStatus());
        };
    }

    @Override
    public String getMessage() {
        return Services.getText(894) + " " + this.traderDeclarationNumber;
    }

    @Override
    public boolean locksActions() {
        return false;
    }

    @Override
    protected boolean cancelExecute(Sending backgroundSending) throws Exception {
        return this.isSendingInConflict();
    }

    @Override
    protected void handleErrorForCurrentSending(Sending sending, Throwable e2) {
    }

    @Override
    protected void handleErrorForSavedSending(String sendingId, Throwable e2) {
    }
}

